% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DemographicTable.R
\name{DemographicTable}
\alias{DemographicTable}
\title{Create Demographic Table}
\usage{
DemographicTable(
  data,
  data.name = substitute(data),
  groups = NULL,
  exclude = NULL,
  exclude_rx,
  include,
  include_rx,
  paired = FALSE,
  robust = TRUE,
  overall = TRUE,
  compare = TRUE,
  pairwise = 3L,
  ...
)
}
\arguments{
\item{data}{a \link[base]{data.frame}}

\item{data.name}{\link[base]{character} scalar, or the argument \link[base]{call} of \code{data}.
A user-friendly name of the input \code{data}.}

\item{groups}{\link[base]{character} scalar or \link[base]{vector},
the name(s) of sub-group(s) for which the summary statistics are provided.
Default \code{NULL} indicating no sub-groups.}

\item{exclude}{\link[base]{character} \link[base]{vector},
the name(s) of variable(s) to be excluded.
Default \code{NULL} indicating no variable are excluded.}

\item{exclude_rx}{(optional) \link[base]{regex},
pattern of the names of the variable(s) to be excluded.}

\item{include}{\link[base]{character} \link[base]{vector},
the name(s) of variable(s) to be included.
Default \code{names(data)} indicating all variables are included.}

\item{include_rx}{(optional) \link[base]{regex},
pattern of the names of the variable(s) to be included.}

\item{paired}{\link[base]{logical} scalar, whether to perform paired test (default \code{FALSE})}

\item{robust}{\link[base]{logical} scalar.
If \code{TRUE} (default), use non-parametric methods for
non-normally distributed \link[base]{numeric} variables.}

\item{overall}{\link[base]{logical} scalar.
If \code{TRUE} (default), a column of overall summary statistics will be provided.}

\item{compare}{\link[base]{logical} scalar.
If \code{TRUE} (default), comparisons between group(s) will be made.}

\item{pairwise}{\link[base]{integer} scalar,
minimum number of groups where pairwise comparisons need to be performed.
Default \code{3L}.}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{DemographicTable} returns an object of S3 class \code{'DemographicTable'},
which is a \link[base]{list} of \link[base]{matrix}-es.
}
\description{
Create a demographic table with simple summary statistics, with optional comparison(s) over one or more groups.
}
\details{
A demographic table with simple summary statistics, with optional comparison(s) over one or more groups, is created.

\link[base]{numeric} variables are summarized in means, standard deviations, medians, inter-quartile-ranges (IQR),
skewness, \eqn{p}-value of Shapiro-Wilk normality test and ranges.
If \code{group} is specified, they are compared using two-sample \link[stats]{t.test},
\link[stats]{wilcox.test} (Wilcoxon / Mann-Whitney), one-way \link[stats]{aov} (ANOVA) and/or
\link[stats]{kruskal.test} (Kruskal-Wallis).

\link[base]{logical} and \link[base]{factor} variables are summarized in counts and percentages.
If \code{group} is specified, they are compared using \link[stats]{prop.test} (chi-squared)
and/or \link[stats]{fisher.test} (Fisher's exact).
}
\examples{
tgr = within(ToothGrowth, expr = { dose = factor(dose) })
DemographicTable(tgr, include = c('supp', 'len', 'dose'))
DemographicTable(tgr, groups = 'supp', include = c('len', 'dose'))
DemographicTable(tgr, groups = 'supp', include = 'len', paired = TRUE)
DemographicTable(tgr, groups = 'supp', include = 'len', compare = FALSE)
DemographicTable(tgr, groups = c('supp', 'dose'), include = 'len')

(tb1 = DemographicTable(CO2, groups = 'Type', include = c('conc', 'uptake')))
CO2_nonchilled = subset(CO2, Treatment == 'nonchilled')
(tb2 = DemographicTable(CO2_nonchilled, groups = 'Type', include = c('conc', 'uptake')))
c(tb1, tb2)

# pairwise comparision
DemographicTable(MASS::survey, groups = 'Fold')

# missing value in `groups`
DemographicTable(MASS::survey, groups = c('M.I'))

}
