% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{rrr_get}
\alias{rrr_get}
\title{Reduced-Rank Regression on Cepstral Coefficients}
\usage{
rrr_get(X, f, frq, nbase, nrank)
}
\arguments{
\item{X}{A numeric matrix of predictors (N x P).}

\item{f}{A numeric matrix of cepstral coefficients.}

\item{frq}{A vector of frequencies in \code{[0,1]}.}

\item{nbase}{Number of Fourier basis functions.}

\item{nrank}{Fixed Rank for the reduced-rank regression.}
}
\value{
A list containing:
\describe{
\item{\code{alph}}{Estimated intercept vector.}
\item{\code{bet}}{Estimated coefficient matrix.}
\item{\code{spechat}}{Estimated log-spectra.}
\item{\code{res}}{Matrix of residuals.}
}
}
\description{
Fits a reduced-rank regression (RRR) between covariates and cepstral coefficients
using a specified maximum rank, and reconstructs log-spectra.
}
\examples{
set.seed(123)
frq <- seq(0, 1, length.out = 16)[2:8]
n <- 5
p <- 2
nbase <- 2

X <- matrix(rnorm(n * p), n, p)

psi <- psi_get(nbase, frq)

true_beta <- matrix(rnorm(p * nbase), p, nbase)
alph <- rnorm(nbase)
f <- X \%*\% true_beta + matrix(alph, n, nbase, byrow = TRUE) +
     matrix(rnorm(n * nbase), n, nbase)

rrr <- rrr_get(X, f, frq, nbase = nbase, nrank = 1)
}
