% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRMetrics.R
\name{CRMetrics}
\alias{CRMetrics}
\title{CRMetrics class object}
\description{
Functions to analyze Cell Ranger count data
}
\examples{

## ------------------------------------------------
## Method `CRMetrics$new`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
}

## ------------------------------------------------
## Method `CRMetrics$addDetailedMetrics`
## ------------------------------------------------

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Run function
crm$addDetailedMetrics()

## ------------------------------------------------
## Method `CRMetrics$addComparison`
## ------------------------------------------------

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add metadata
crm$metadata$sex <- c("male","female")

# Add comparison group
crm$addComparison(comp.group = "sex")

## ------------------------------------------------
## Method `CRMetrics$plotSamples`
## ------------------------------------------------

sample.names <- c("sample1", "sample2")

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})
names(testdata.cms) <- sample.names

# Create metadata
metadata <- data.frame(sample = sample.names,
sex = c("male","female"),
condition = c("a","b"))

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, metadata = metadata, n.cores = 1)

# Plot
crm$plotSamples(comp.group = "sex", second.comp.group = "condition")

## ------------------------------------------------
## Method `CRMetrics$plotSummaryMetrics`
## ------------------------------------------------

\donttest{
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add summary metrics
crm$addSummaryFromCms()

crm$plotSummaryMetrics(plot.geom = "point")
}

## ------------------------------------------------
## Method `CRMetrics$plotDetailedMetrics`
## ------------------------------------------------

\donttest{
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add detailed metrics
crm$addDetailedMetrics()

# Plot
crm$plotDetailedMetrics()
}

## ------------------------------------------------
## Method `CRMetrics$plotEmbedding`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding() 

crm$plotEmbedding()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$plotDepth`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Plot
crm$plotDepth()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$plotMitoFraction`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Plot
crm$plotMitoFraction()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$detectDoublets`
## ------------------------------------------------

\dontrun{
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)


# Detect doublets
crm$detectDoublets(method = "scrublet", 
conda.path = "/opt/software/miniconda/4.12.0/condabin/conda")
}

## ------------------------------------------------
## Method `CRMetrics$doPreprocessing`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Perform preprocessing
crm$doPreprocessing(preprocess = "pagoda2")
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$createEmbedding`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$filterCms`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()


# Filter CMs
crm$filterCms(depth.cutoff = 1e3, mito.cutoff = 0.05)
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$selectMetrics`
## ------------------------------------------------

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Select metrics
crm$selectMetrics()
selection.metrics <- crm$selectMetrics(c(1:4))

## ------------------------------------------------
## Method `CRMetrics$plotFilteredCells`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Plot and extract result
crm$plotFilteredCells(type = "embedding")
filtered.cells <- crm$plotFilteredCells(type = "export")
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$getConosDepth`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Get Conos depth
crm$getConosDepth()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$getMitoFraction`
## ------------------------------------------------

\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Get mito. fraction
crm$getMitoFraction(species = c("human", "mouse"))
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}

## ------------------------------------------------
## Method `CRMetrics$prepareCellbender`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data")
crm$prepareCellbender()
}

## ------------------------------------------------
## Method `CRMetrics$saveCellbenderScript`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
}

## ------------------------------------------------
## Method `CRMetrics$getExpectedCells`
## ------------------------------------------------

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Get summary
crm$addSummaryFromCms()

# Get no. cells
crm$getExpectedCells()

## ------------------------------------------------
## Method `CRMetrics$getTotalDroplets`
## ------------------------------------------------

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add summary
crm$addSummaryFromCms()

# Get no. droplets
crm$getTotalDroplets()

## ------------------------------------------------
## Method `CRMetrics$addCms`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

crm$addCms(cms = testdata.cms)
}

## ------------------------------------------------
## Method `CRMetrics$plotCbTraining`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbTraining()
}

## ------------------------------------------------
## Method `CRMetrics$plotCbCellProbs`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run the CellBender script
crm$plotCbCellProbs()
}

## ------------------------------------------------
## Method `CRMetrics$plotCbAmbExp`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbAmbExp()
}

## ------------------------------------------------
## Method `CRMetrics$plotCbAmbGenes`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbAmbGenes()
}

## ------------------------------------------------
## Method `CRMetrics$addSummaryFromCms`
## ------------------------------------------------

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add summary
crm$addSummaryFromCms()

## ------------------------------------------------
## Method `CRMetrics$runSoupX`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$runSoupX()
}

## ------------------------------------------------
## Method `CRMetrics$plotSoupX`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$runSoupX()
crm$plotSoupX()
}

## ------------------------------------------------
## Method `CRMetrics$plotCbCells`
## ------------------------------------------------

\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbCells()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{metadata}}{(default = NULL)}

\item{\code{data.path}}{(default = NULL)}

\item{\code{summary.metrics}}{(default = NULL)}

\item{\code{detailed.metrics}}{(default = NULL)}

\item{\code{comp.group}}{(default = NULL)}

\item{\code{verbose}}{(default = TRUE)}

\item{\code{theme}}{(default = NULL)}

\item{\code{n.cores}}{(default = 1)
Initialize a CRMetrics object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CRMetrics-new}{\code{CRMetrics$new()}}
\item \href{#method-CRMetrics-addDetailedMetrics}{\code{CRMetrics$addDetailedMetrics()}}
\item \href{#method-CRMetrics-addComparison}{\code{CRMetrics$addComparison()}}
\item \href{#method-CRMetrics-plotSamples}{\code{CRMetrics$plotSamples()}}
\item \href{#method-CRMetrics-plotSummaryMetrics}{\code{CRMetrics$plotSummaryMetrics()}}
\item \href{#method-CRMetrics-plotDetailedMetrics}{\code{CRMetrics$plotDetailedMetrics()}}
\item \href{#method-CRMetrics-plotEmbedding}{\code{CRMetrics$plotEmbedding()}}
\item \href{#method-CRMetrics-plotDepth}{\code{CRMetrics$plotDepth()}}
\item \href{#method-CRMetrics-plotMitoFraction}{\code{CRMetrics$plotMitoFraction()}}
\item \href{#method-CRMetrics-detectDoublets}{\code{CRMetrics$detectDoublets()}}
\item \href{#method-CRMetrics-doPreprocessing}{\code{CRMetrics$doPreprocessing()}}
\item \href{#method-CRMetrics-createEmbedding}{\code{CRMetrics$createEmbedding()}}
\item \href{#method-CRMetrics-filterCms}{\code{CRMetrics$filterCms()}}
\item \href{#method-CRMetrics-selectMetrics}{\code{CRMetrics$selectMetrics()}}
\item \href{#method-CRMetrics-plotFilteredCells}{\code{CRMetrics$plotFilteredCells()}}
\item \href{#method-CRMetrics-getConosDepth}{\code{CRMetrics$getConosDepth()}}
\item \href{#method-CRMetrics-getMitoFraction}{\code{CRMetrics$getMitoFraction()}}
\item \href{#method-CRMetrics-prepareCellbender}{\code{CRMetrics$prepareCellbender()}}
\item \href{#method-CRMetrics-saveCellbenderScript}{\code{CRMetrics$saveCellbenderScript()}}
\item \href{#method-CRMetrics-getExpectedCells}{\code{CRMetrics$getExpectedCells()}}
\item \href{#method-CRMetrics-getTotalDroplets}{\code{CRMetrics$getTotalDroplets()}}
\item \href{#method-CRMetrics-addCms}{\code{CRMetrics$addCms()}}
\item \href{#method-CRMetrics-plotCbTraining}{\code{CRMetrics$plotCbTraining()}}
\item \href{#method-CRMetrics-plotCbCellProbs}{\code{CRMetrics$plotCbCellProbs()}}
\item \href{#method-CRMetrics-plotCbAmbExp}{\code{CRMetrics$plotCbAmbExp()}}
\item \href{#method-CRMetrics-plotCbAmbGenes}{\code{CRMetrics$plotCbAmbGenes()}}
\item \href{#method-CRMetrics-addSummaryFromCms}{\code{CRMetrics$addSummaryFromCms()}}
\item \href{#method-CRMetrics-runSoupX}{\code{CRMetrics$runSoupX()}}
\item \href{#method-CRMetrics-plotSoupX}{\code{CRMetrics$plotSoupX()}}
\item \href{#method-CRMetrics-plotCbCells}{\code{CRMetrics$plotCbCells()}}
\item \href{#method-CRMetrics-clone}{\code{CRMetrics$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-new"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-new}{}}}
\subsection{Method \code{new()}}{
To initialize new object, 'data.path' or 'cms' is needed. 'metadata' is also recommended, but not required.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$new(
  data.path = NULL,
  metadata = NULL,
  cms = NULL,
  sample.names = NULL,
  unique.names = TRUE,
  sep.cells = "!!",
  comp.group = NULL,
  verbose = TRUE,
  theme = theme_bw(),
  n.cores = 1,
  sep.meta = ",",
  raw.meta = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data.path}}{character Path to directory with Cell Ranger count data, one directory per sample (default = NULL).}

\item{\code{metadata}}{data.frame or character Path to metadata file (comma-separated) or name of metadata dataframe object. Metadata must contain a column named 'sample' containing sample names that must match folder names in 'data.path' (default = NULL).}

\item{\code{cms}}{list List with count matrices (default = NULL)}

\item{\code{sample.names}}{character Sample names. Only relevant is cms is provided (default = NULL)}

\item{\code{unique.names}}{logical Create unique cell names. Only relevant if cms is provided (default = TRUE)}

\item{\code{sep.cells}}{character Sample-cell separator. Only relevant if cms is provided and \code{unique.names=TRUE} (default = "!!")}

\item{\code{comp.group}}{character A group present in the metadata to compare the metrics by, can be added with addComparison (default = NULL).}

\item{\code{verbose}}{logical Print messages or not (default = TRUE).}

\item{\code{theme}}{ggplot2 theme (default: theme_bw()).}

\item{\code{n.cores}}{integer Number of cores for the calculations (default = self$n.cores).}

\item{\code{sep.meta}}{character Separator for metadata file (default = ",")}

\item{\code{raw.meta}}{logical Keep metadata in its raw format. If FALSE, classes will be converted using "type.convert" (default = FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
CRMetrics object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-addDetailedMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-addDetailedMetrics}{}}}
\subsection{Method \code{addDetailedMetrics()}}{
Function to read in detailed metrics. This is not done upon initialization for speed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$addDetailedMetrics(
  min.transcripts.per.cell = 100,
  raw = FALSE,
  symbol = TRUE,
  sep = "!!",
  cellbender = FALSE,
  unique.names = TRUE,
  data.path = self$data.path,
  sample.names = self$metadata$sample,
  n.cores = self$n.cores,
  verbose = self$verbose
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min.transcripts.per.cell}}{numeric Minimal number of transcripts per cell (default = 100)}

\item{\code{raw}}{logical Add raw count matrices from Cell Ranger output. Cannot be combined with \code{cellbender=TRUE} (default = FALSE)}

\item{\code{symbol}}{character The type of gene IDs to use, SYMBOL (TRUE) or ENSEMBLE (default = TRUE)}

\item{\code{sep}}{character Separator for cell names (default = "!!").}

\item{\code{cellbender}}{logical Add CellBender filtered count matrices in HDF5 format. Requires that "cellbender" is in the names of the files (default = FALSE)}

\item{\code{unique.names}}{logical Make cell names unique based on \code{sep} parameter (default = TRUE)}

\item{\code{data.path}}{character Path to cellranger count data (default = self$data.path).}

\item{\code{sample.names}}{character Vector containing sample names (default = self$metadata$sample).}

\item{\code{n.cores}}{integer Number of cores for the calculations (default = self$n.cores).}

\item{\code{verbose}}{logical Print messages or not (default = self$verbose).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Count matrices
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Run function
crm$addDetailedMetrics()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-addComparison"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-addComparison}{}}}
\subsection{Method \code{addComparison()}}{
Add comparison group for statistical testing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$addComparison(comp.group, metadata = self$metadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{comp.group}}{character Comparison metric (default = self$comp.group).}

\item{\code{metadata}}{data.frame Metadata for samples (default = self$metadata).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add metadata
crm$metadata$sex <- c("male","female")

# Add comparison group
crm$addComparison(comp.group = "sex")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotSamples"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotSamples}{}}}
\subsection{Method \code{plotSamples()}}{
Plot the number of samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotSamples(
  comp.group = self$comp.group,
  h.adj = 0.05,
  exact = FALSE,
  metadata = self$metadata,
  second.comp.group = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{comp.group}}{character Comparison metric, must match a column name of metadata (default = self$comp.group).}

\item{\code{h.adj}}{numeric Position of statistics test p value as \% of max(y) (default = 0.05).}

\item{\code{exact}}{logical Whether to calculate exact p values (default = FALSE).}

\item{\code{metadata}}{data.frame Metadata for samples (default = self$metadata).}

\item{\code{second.comp.group}}{character Second comparison metric, must match a column name of metadata (default = NULL).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sample.names <- c("sample1", "sample2")

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})
names(testdata.cms) <- sample.names

# Create metadata
metadata <- data.frame(sample = sample.names,
sex = c("male","female"),
condition = c("a","b"))

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, metadata = metadata, n.cores = 1)

# Plot
crm$plotSamples(comp.group = "sex", second.comp.group = "condition")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotSummaryMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotSummaryMetrics}{}}}
\subsection{Method \code{plotSummaryMetrics()}}{
Plot all summary stats or a selected list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotSummaryMetrics(
  comp.group = self$comp.group,
  second.comp.group = NULL,
  metrics = NULL,
  h.adj = 0.05,
  plot.stat = TRUE,
  stat.test = c("non-parametric", "parametric"),
  exact = FALSE,
  metadata = self$metadata,
  summary.metrics = self$summary.metrics,
  plot.geom = "bar",
  se = FALSE,
  group.reg.lines = FALSE,
  secondary.testing = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{comp.group}}{character Comparison metric (default = self$comp.group).}

\item{\code{second.comp.group}}{character Second comparison metric, used for the metric "samples per group" or when "comp.group" is a numeric or an integer (default = NULL).}

\item{\code{metrics}}{character Metrics to plot (default = NULL).}

\item{\code{h.adj}}{numeric Position of statistics test p value as \% of max(y) (default = 0.05)}

\item{\code{plot.stat}}{logical Show statistics in plot. Will be FALSE if "comp.group" = "sample" or if "comp.group" is a numeric or an integer (default = TRUE)}

\item{\code{stat.test}}{character Statistical test to perform to compare means. Can either be "non-parametric" or "parametric" (default = "non-parametric").}

\item{\code{exact}}{logical Whether to calculate exact p values (default = FALSE).}

\item{\code{metadata}}{data.frame Metadata for samples (default = self$metadata).}

\item{\code{summary.metrics}}{data.frame Summary metrics (default = self$summary.metrics).}

\item{\code{plot.geom}}{character Which geometric is used to plot the data (default = "point").}

\item{\code{se}}{logical For regression lines, show SE (default = FALSE)}

\item{\code{group.reg.lines}}{logical For regression lines, if FALSE show one line, if TRUE show line per group defined by second.comp.group (default = FALSE)}

\item{\code{secondary.testing}}{logical Whether to show post hoc testing (default = TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add summary metrics
crm$addSummaryFromCms()

crm$plotSummaryMetrics(plot.geom = "point")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotDetailedMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotDetailedMetrics}{}}}
\subsection{Method \code{plotDetailedMetrics()}}{
Plot detailed metrics from the detailed.metrics object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotDetailedMetrics(
  comp.group = self$comp.group,
  detailed.metrics = self$detailed.metrics,
  metadata = self$metadata,
  metrics = NULL,
  plot.geom = "violin",
  data.path = self$data.path,
  hline = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{comp.group}}{character Comparison metric (default = self$comp.group).}

\item{\code{detailed.metrics}}{data.frame Object containing the count matrices (default = self$detailed.metrics).}

\item{\code{metadata}}{data.frame Metadata for samples (default = self$metadata).}

\item{\code{metrics}}{character Metrics to plot. NULL plots both plots (default = NULL).}

\item{\code{plot.geom}}{character How to plot the data (default = "violin").}

\item{\code{data.path}}{character Path to cellranger count data (default = self$data.path).}

\item{\code{hline}}{logical Whether to show median as horizontal line (default = TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add detailed metrics
crm$addDetailedMetrics()

# Plot
crm$plotDetailedMetrics()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotEmbedding"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotEmbedding}{}}}
\subsection{Method \code{plotEmbedding()}}{
Plot cells in embedding using Conos and color by depth and doublets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotEmbedding(
  depth = FALSE,
  doublet.method = NULL,
  doublet.scores = FALSE,
  depth.cutoff = 1000,
  mito.frac = FALSE,
  mito.cutoff = 0.05,
  species = c("human", "mouse"),
  size = 0.3,
  sep = "!!",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{depth}}{logical Plot depth or not (default = FALSE).}

\item{\code{doublet.method}}{character Doublet detection method (default = NULL).}

\item{\code{doublet.scores}}{logical Plot doublet scores or not (default = FALSE).}

\item{\code{depth.cutoff}}{numeric Depth cutoff (default = 1e3).}

\item{\code{mito.frac}}{logical Plot mitochondrial fraction or not (default = FALSE).}

\item{\code{mito.cutoff}}{numeric Mitochondrial fraction cutoff (default = 0.05).}

\item{\code{species}}{character Species to calculate the mitochondrial fraction for (default = c("human","mouse")).}

\item{\code{size}}{numeric Dot size (default = 0.3)}

\item{\code{sep}}{character Separator for creating unique cell names (default = "!!")}

\item{\code{...}}{Plotting parameters passed to \code{sccore::embeddingPlot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding() 

crm$plotEmbedding()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotDepth"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotDepth}{}}}
\subsection{Method \code{plotDepth()}}{
Plot the sequencing depth in histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotDepth(cutoff = 1000, samples = self$metadata$sample, sep = "!!")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{numeric The depth cutoff to color the cells in the embedding (default = 1e3).}

\item{\code{samples}}{character Sample names to include for plotting (default = $metadata$sample).}

\item{\code{sep}}{character Separator for creating unique cell names (default = "!!")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Plot
crm$plotDepth()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotMitoFraction"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotMitoFraction}{}}}
\subsection{Method \code{plotMitoFraction()}}{
Plot the mitochondrial fraction in histogram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotMitoFraction(
  cutoff = 0.05,
  species = c("human", "mouse"),
  samples = self$metadata$sample,
  sep = "!!"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{numeric The mito. fraction cutoff to color the embedding (default = 0.05)}

\item{\code{species}}{character Species to calculate the mitochondrial fraction for (default = "human")}

\item{\code{samples}}{character Sample names to include for plotting (default = $metadata$sample)}

\item{\code{sep}}{character Separator for creating unique cell names (default = "!!")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Plot
crm$plotMitoFraction()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-detectDoublets"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-detectDoublets}{}}}
\subsection{Method \code{detectDoublets()}}{
Detect doublet cells.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$detectDoublets(
  method = c("scrublet", "doubletdetection"),
  cms = self$cms,
  env = "r-reticulate",
  conda.path = system("whereis conda"),
  n.cores = self$n.cores,
  verbose = self$verbose,
  args = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{character Which method to use, either \code{scrublet} or \code{doubletdetection} (default="scrublet").}

\item{\code{cms}}{list List containing the count matrices (default=self$cms).}

\item{\code{env}}{character Environment to run python in (default="r-reticulate").}

\item{\code{conda.path}}{character Path to conda environment (default=system("whereis conda")).}

\item{\code{n.cores}}{integer Number of cores to use (default = self$n.cores)}

\item{\code{verbose}}{logical Print messages or not (default = self$verbose)}

\item{\code{args}}{list A list with additional arguments for either \code{DoubletDetection} or \code{scrublet}. Please check the respective manuals.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.frame
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)


# Detect doublets
crm$detectDoublets(method = "scrublet", 
conda.path = "/opt/software/miniconda/4.12.0/condabin/conda")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-doPreprocessing"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-doPreprocessing}{}}}
\subsection{Method \code{doPreprocessing()}}{
Perform conos preprocessing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$doPreprocessing(
  cms = self$cms,
  preprocess = c("pagoda2", "seurat"),
  min.transcripts.per.cell = 100,
  verbose = self$verbose,
  n.cores = self$n.cores,
  get.largevis = FALSE,
  tsne = FALSE,
  make.geneknn = FALSE,
  cluster = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cms}}{list List containing the count matrices (default = self$cms).}

\item{\code{preprocess}}{character Method to use for preprocessing (default = c("pagoda2","seurat")).}

\item{\code{min.transcripts.per.cell}}{numeric Minimal transcripts per cell (default = 100)}

\item{\code{verbose}}{logical Print messages or not (default = self$verbose).}

\item{\code{n.cores}}{integer Number of cores for the calculations (default = self$n.cores).}

\item{\code{get.largevis}}{logical For Pagoda2, create largeVis embedding (default = FALSE)}

\item{\code{tsne}}{logical Create tSNE embedding (default = FALSE)}

\item{\code{make.geneknn}}{logical For Pagoda2, estimate gene kNN (default = FALSE)}

\item{\code{cluster}}{logical For Seurat, estimate clusters (default = FALSE)}

\item{\code{...}}{Additional arguments for \code{Pagaoda2::basicP2Proc} or \code{conos:::basicSeuratProc}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Conos object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Perform preprocessing
crm$doPreprocessing(preprocess = "pagoda2")
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-createEmbedding"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-createEmbedding}{}}}
\subsection{Method \code{createEmbedding()}}{
Create Conos embedding.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$createEmbedding(
  cms = self$cms.preprocessed,
  verbose = self$verbose,
  n.cores = self$n.cores,
  arg.buildGraph = list(),
  arg.findCommunities = list(n.iterations = 1),
  arg.embedGraph = list(method = "UMAP")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cms}}{list List containing the preprocessed count matrices (default = self$cms.preprocessed).}

\item{\code{verbose}}{logical Print messages or not (default = self$verbose).}

\item{\code{n.cores}}{integer Number of cores for the calculations (default = self$n.cores).}

\item{\code{arg.buildGraph}}{list A list with additional arguments for the \code{buildGraph} function in Conos (default = list())}

\item{\code{arg.findCommunities}}{list A list with additional arguments for the \code{findCommunities} function in Conos (default = list(n.iterations = 1)) # Should be updated when Conos issue #123 is resolved}

\item{\code{arg.embedGraph}}{list A list with additional arguments for the \code{embedGraph} function in Conos (default = list(method = "UMAP))}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Conos object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-filterCms"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-filterCms}{}}}
\subsection{Method \code{filterCms()}}{
Filter cells based on depth, mitochondrial fraction and doublets from the count matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$filterCms(
  min.transcripts.per.cell = 100,
  depth.cutoff = NULL,
  mito.cutoff = NULL,
  doublets = NULL,
  species = c("human", "mouse"),
  samples.to.exclude = NULL,
  verbose = self$verbose,
  sep = "!!"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min.transcripts.per.cell}}{numeric Minimal transcripts per cell (default = 100)}

\item{\code{depth.cutoff}}{numeric Depth cutoff (default = NULL).}

\item{\code{mito.cutoff}}{numeric Mitochondrial fraction cutoff (default = NULL).}

\item{\code{doublets}}{character Doublet detection method to use (default = NULL).}

\item{\code{species}}{character Species to calculate the mitochondrial fraction for (default = "human").}

\item{\code{samples.to.exclude}}{character Sample names to exclude (default = NULL)}

\item{\code{verbose}}{logical Show progress (default = self$verbose)}

\item{\code{sep}}{character Separator for creating unique cell names (default = "!!")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list of filtered count matrices
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()


# Filter CMs
crm$filterCms(depth.cutoff = 1e3, mito.cutoff = 0.05)
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-selectMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-selectMetrics}{}}}
\subsection{Method \code{selectMetrics()}}{
Select metrics from summary.metrics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$selectMetrics(ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{character Metric id to select (default = NULL).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
vector
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Select metrics
crm$selectMetrics()
selection.metrics <- crm$selectMetrics(c(1:4))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotFilteredCells"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotFilteredCells}{}}}
\subsection{Method \code{plotFilteredCells()}}{
Plot filtered cells in an embedding, in a bar plot, on a tile or export the data frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotFilteredCells(
  type = c("embedding", "bar", "tile", "export"),
  depth = TRUE,
  depth.cutoff = 1000,
  doublet.method = NULL,
  mito.frac = TRUE,
  mito.cutoff = 0.05,
  species = c("human", "mouse"),
  size = 0.3,
  sep = "!!",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character The type of plot to use: embedding, bar, tile or export (default = c("embedding","bar","tile","export")).}

\item{\code{depth}}{logical Plot the depth or not (default = TRUE).}

\item{\code{depth.cutoff}}{numeric Depth cutoff, either a single number or a vector with cutoff per sample and with sampleIDs as names (default = 1e3).}

\item{\code{doublet.method}}{character Method to detect doublets (default = NULL).}

\item{\code{mito.frac}}{logical Plot the mitochondrial fraction or not (default = TRUE).}

\item{\code{mito.cutoff}}{numeric Mitochondrial fraction cutoff, either a single number or a vector with cutoff per sample and with sampleIDs as names (default = 0.05).}

\item{\code{species}}{character Species to calculate the mitochondrial fraction for (default = c("human","mouse")).}

\item{\code{size}}{numeric Dot size (default = 0.3)}

\item{\code{sep}}{character Separator for creating unique cell names (default = "!!")}

\item{\code{...}}{Plotting parameters passed to \code{sccore::embeddingPlot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object or data frame
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Plot and extract result
crm$plotFilteredCells(type = "embedding")
filtered.cells <- crm$plotFilteredCells(type = "export")
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-getConosDepth"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-getConosDepth}{}}}
\subsection{Method \code{getConosDepth()}}{
Extract sequencing depth from Conos object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$getConosDepth()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data frame
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Get Conos depth
crm$getConosDepth()
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-getMitoFraction"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-getMitoFraction}{}}}
\subsection{Method \code{getMitoFraction()}}{
Calculate the fraction of mitochondrial genes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$getMitoFraction(species = c("human", "mouse"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{species}}{character Species to calculate the mitochondrial fraction for (default = "human").}

\item{\code{force}}{logical Force update of stored vector (default = FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data frame
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
if (requireNamespace("pagoda2", quietly = TRUE)) {
if (requireNamespace("conos", quietly = TRUE)) {
# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Create embedding
crm$doPreprocessing()
crm$createEmbedding()

# Get mito. fraction
crm$getMitoFraction(species = c("human", "mouse"))
} else {
message("Package 'conos' not available.")
}
} else {
message("Package 'pagoda2' not available.")
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-prepareCellbender"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-prepareCellbender}{}}}
\subsection{Method \code{prepareCellbender()}}{
Create plots and script call for CellBender
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$prepareCellbender(
  shrinkage = 100,
  show.expected.cells = TRUE,
  show.total.droplets = TRUE,
  expected.cells = NULL,
  total.droplets = NULL,
  cms.raw = self$cms.raw,
  umi.counts = self$cellbender$umi.counts,
  data.path = self$data.path,
  samples = self$metadata$sample,
  verbose = self$verbose,
  n.cores = self$n.cores,
  unique.names = FALSE,
  sep = "!!"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shrinkage}}{integer Select every nth UMI count per cell for plotting. Improves plotting speed drastically. To plot all cells, set to 1 (default = 100)}

\item{\code{show.expected.cells}}{logical Plot line depicting expected number of cells (default = TRUE)}

\item{\code{show.total.droplets}}{logical Plot line depicting total droplets included for CellBender run (default = TRUE)}

\item{\code{expected.cells}}{named numeric If NULL, expected cells will be deduced from the number of cells per sample identified by Cell Ranger. Otherwise, a named vector of expected cells with sample IDs as names. Sample IDs must match those in summary.metrics (default: stored named vector)}

\item{\code{total.droplets}}{named numeric If NULL, total droplets included will be deduced from expected cells multiplied by 3. Otherwise, a named vector of total droplets included with sample IDs as names. Sample IDs must match those in summary.metrics (default: stored named vector)}

\item{\code{cms.raw}}{list Raw count matrices from HDF5 Cell Ranger outputs (default = self$cms.raw)}

\item{\code{umi.counts}}{list UMI counts calculated as column sums of raw count matrices from HDF5 Cell Ranger outputs (default: stored list)}

\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}

\item{\code{verbose}}{logical Show progress (default: stored vector)}

\item{\code{n.cores}}{integer Number of cores (default: stored vector)}

\item{\code{unique.names}}{logical Create unique cell names (default = FALSE)}

\item{\code{sep}}{character Separator for creating unique cell names (default = "!!")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object and bash script
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data")
crm$prepareCellbender()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-saveCellbenderScript"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-saveCellbenderScript}{}}}
\subsection{Method \code{saveCellbenderScript()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$saveCellbenderScript(
  file = "cellbender_script.sh",
  fpr = 0.01,
  epochs = 150,
  use.gpu = TRUE,
  expected.cells = NULL,
  total.droplets = NULL,
  data.path = self$data.path,
  samples = self$metadata$sample,
  args = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{character File name for CellBender script. Will be stored in \code{data.path} (default: "cellbender_script.sh")}

\item{\code{fpr}}{numeric False positive rate for CellBender (default = 0.01)}

\item{\code{epochs}}{integer Number of epochs for CellBender (default = 150)}

\item{\code{use.gpu}}{logical Use CUDA capable GPU (default = TRUE)}

\item{\code{expected.cells}}{named numeric If NULL, expected cells will be deduced from the number of cells per sample identified by Cell Ranger. Otherwise, a named vector of expected cells with sample IDs as names. Sample IDs must match those in summary.metrics (default: stored named vector)}

\item{\code{total.droplets}}{named numeric If NULL, total droplets included will be deduced from expected cells multiplied by 3. Otherwise, a named vector of total droplets included with sample IDs as names. Sample IDs must match those in summary.metrics (default: stored named vector)}

\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}

\item{\code{args}}{character (optional) Additional parameters for CellBender}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
bash script
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-getExpectedCells"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-getExpectedCells}{}}}
\subsection{Method \code{getExpectedCells()}}{
Extract the expected number of cells per sample based on the Cell Ranger summary metrics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$getExpectedCells(samples = self$metadata$sample)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Get summary
crm$addSummaryFromCms()

# Get no. cells
crm$getExpectedCells()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-getTotalDroplets"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-getTotalDroplets}{}}}
\subsection{Method \code{getTotalDroplets()}}{
Get the total number of droplets included in the CellBender estimations. Based on the Cell Ranger summary metrics and multiplied by a preset multiplier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$getTotalDroplets(samples = self$metadata$sample, multiplier = 3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{samples}}{character Samples names to include (default = self$metadata$sample)}

\item{\code{multiplier}}{numeric Number to multiply expected number of cells with (default = 3)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add summary
crm$addSummaryFromCms()

# Get no. droplets
crm$getTotalDroplets()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-addCms"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-addCms}{}}}
\subsection{Method \code{addCms()}}{
Add a list of count matrices to the CRMetrics object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$addCms(
  cms,
  sample.names = NULL,
  unique.names = TRUE,
  sep = "!!",
  n.cores = self$n.cores
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cms}}{list List of count matrices}

\item{\code{sample.names}}{character Vector of sample names. If NULL, sample.names are extracted from cms (default = NULL)}

\item{\code{unique.names}}{logical Create unique cell names (default = TRUE)}

\item{\code{sep}}{character Separator used to create unique cell names (default = "!!")}

\item{\code{n.cores}}{integer Number of cores to use (default = self$n.cores)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")

# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

crm$addCms(cms = testdata.cms)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotCbTraining"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotCbTraining}{}}}
\subsection{Method \code{plotCbTraining()}}{
Plot the results from the CellBender estimations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotCbTraining(
  data.path = self$data.path,
  samples = self$metadata$sample
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbTraining()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotCbCellProbs"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotCbCellProbs}{}}}
\subsection{Method \code{plotCbCellProbs()}}{
Plot the CellBender assigned cell probabilities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotCbCellProbs(
  data.path = self$data.path,
  samples = self$metadata$sample
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run the CellBender script
crm$plotCbCellProbs()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotCbAmbExp"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotCbAmbExp}{}}}
\subsection{Method \code{plotCbAmbExp()}}{
Plot the estimated ambient gene expression per sample from CellBender calculations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotCbAmbExp(
  cutoff = 0.005,
  data.path = self$data.path,
  samples = self$metadata$sample
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{numeric Horizontal line included in the plot to indicate highly expressed ambient genes (default = 0.005)}

\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbAmbExp()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotCbAmbGenes"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotCbAmbGenes}{}}}
\subsection{Method \code{plotCbAmbGenes()}}{
Plot the most abundant estimated ambient genes from the CellBender calculations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotCbAmbGenes(
  cutoff = 0.005,
  data.path = self$data.path,
  samples = self$metadata$sample
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{numeric Cutoff of ambient gene expression to use to extract ambient genes per sample}

\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbAmbGenes()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-addSummaryFromCms"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-addSummaryFromCms}{}}}
\subsection{Method \code{addSummaryFromCms()}}{
Add summary metrics from a list of count matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$addSummaryFromCms(
  cms = self$cms,
  n.cores = self$n.cores,
  verbose = self$verbose
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cms}}{list A list of filtered count matrices (default = self$cms)}

\item{\code{n.cores}}{integer Number of cores to use (default = self$n.cores)}

\item{\code{verbose}}{logical Show progress (default = self$verbose)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.frame
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Simulate data
testdata.cms <- lapply(seq_len(2), \(x) {
out <- Matrix::rsparsematrix(2e3, 1e3, 0.1)
out[out < 0] <- 1
dimnames(out) <- list(sapply(seq_len(2e3), \(x) paste0("gene",x)),
sapply(seq_len(1e3), \(x) paste0("cell",x)))
return(out)
})

# Initialize
crm <- CRMetrics$new(cms = testdata.cms, sample.names = c("sample1", "sample2"), n.cores = 1)

# Add summary
crm$addSummaryFromCms()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-runSoupX"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-runSoupX}{}}}
\subsection{Method \code{runSoupX()}}{
Run SoupX ambient RNA estimation and correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$runSoupX(
  data.path = self$data.path,
  samples = self$metadata$sample,
  n.cores = self$n.cores,
  verbose = self$verbose,
  arg.load10X = list(),
  arg.autoEstCont = list(),
  arg.adjustCounts = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}

\item{\code{n.cores}}{numeric Number of cores (default = self$n.cores)}

\item{\code{verbose}}{logical Show progress (default = self$verbose)}

\item{\code{arg.load10X}}{list A list with additional parameters for \code{SoupX::load10X} (default = list())}

\item{\code{arg.autoEstCont}}{list A list with additional parameters for \code{SoupX::autoEstCont} (default = list())}

\item{\code{arg.adjustCounts}}{list A list with additional parameters for \code{SoupX::adjustCounts} (default = list())}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List containing a list with corrected counts, and a data.frame containing plotting estimations
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$runSoupX()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotSoupX"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotSoupX}{}}}
\subsection{Method \code{plotSoupX()}}{
Plot the results from the SoupX estimations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotSoupX(plot.df = self$soupx$plot.df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot.df}}{data.frame SoupX estimations (default = self$soupx$plot.df)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$runSoupX()
crm$plotSoupX()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-plotCbCells"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-plotCbCells}{}}}
\subsection{Method \code{plotCbCells()}}{
Plot CellBender cell estimations against the estimated cell numbers from Cell Ranger
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$plotCbCells(
  data.path = self$data.path,
  samples = self$metadata$sample
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data.path}}{character Path to Cell Ranger outputs (default = self$data.path)}

\item{\code{samples}}{character Sample names to include (default = self$metadata$sample)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
crm <- CRMetrics$new(data.path = "/path/to/count/data/")
crm$prepareCellbender()
crm$saveCellbenderScript()
## Run CellBender script
crm$plotCbCells()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CRMetrics-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CRMetrics-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CRMetrics$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
