% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lbsFindDuplicateTitles}
\alias{lbsFindDuplicateTitles}
\title{Find documents to be merged (**EXPERIMENTAL**)}
\usage{
lbsFindDuplicateTitles(conn, surveyDescription = NULL,
  ignoreTitles.like = NULL, aggressiveness = 1)
}
\arguments{
\item{conn}{connection object, see \code{\link{lbsConnect}}.}

\item{surveyDescription}{character string or \code{NULL}; survey description to restrict to or \code{NULL}.}

\item{ignoreTitles.like}{character vector of SQL-LIKE patterns to match documents' titles to be ignored or \code{NULL}.}

\item{aggressiveness}{nonnegative integer; \code{0} for showing only exact matches;
the higher the value, the more documents will be proposed.}
}
\value{
A numeric vector of user-selected documents' identifiers to be removed.
}
\description{
Indicates, by finding similarities between documents' titles,
 groups of documents that possibly should be merged.
}
\details{
The function determines fuzzy similarity measures of the titles. Its
specificity is controlled by the \code{aggressiveness} parameter.

Search results are presented in a convenient-to-use graphical dialog box.
The function tries to order the groups of documents according
to their relevance (**EXPERIMENTAL** algorithm).
Note that the calculation often takes a few minutes!

The \code{ignoreTitles.like} parameter determines search patterns in an SQL \code{LIKE} format,
i.e. an underscore \code{_} matches a single character and a percent sign
\code{\%} matches any set of characters. The search is case-insensitive.
}
\examples{
\dontrun{
conn <- lbsConnect("Bibliometrics.db");
## ...
listdoc <- lbsFindDuplicateTitles(conn,
   ignoreTitles.like=c("\\\%In this issue\\\%", "\\\%Editorial", "\\\%Introduction",
   "Letter to \\\%", "\\\%Preface"),
   aggressiveness=2);
lbsDeleteDocuments(conn, listdoc);
dbCommit(conn);
## ...}
}
\seealso{
\code{\link{lbsDeleteDocuments}}, \code{\link{lbsFindDuplicateAuthors}}, \code{\link{lbsGetInfoDocuments}}
}

