% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsmb_ddp.R
\name{dsmb_ddp}
\alias{dsmb_ddp}
\title{Outputs the DSMB-DDP AE summary tables in Excel format per UHN template}
\usage{
dsmb_ddp(
  protocol,
  setwd,
  title,
  comp = NULL,
  pi,
  presDate,
  cutDate,
  boundDate = NULL,
  subjID,
  subjID_ineligText = NULL,
  baseline_datasets,
  ae_dataset,
  ineligVar = NULL,
  ineligVarText = NULL,
  genderVar,
  enrolDtVar,
  ae_detailVar,
  ae_categoryVar = NULL,
  ae_severityVar,
  ae_onsetDtVar,
  ae_detailOtherText = NULL,
  ae_detailOtherVar = NULL,
  ae_verbatimVar = NULL,
  ae_attribVars = NULL,
  ae_attribVarsName = NULL,
  ae_attribVarText = NULL,
  related_ae = FALSE,
  numSubj = NULL,
  fileNameUnderscore = TRUE
)
}
\arguments{
\item{protocol}{study protocol name (uppercase, no spaces permitted)}

\item{setwd}{directory to write Excel summary files to}

\item{title}{full character vector with name of study}

\item{comp}{baseline comparison group. For example, cohort (if provided)}

\item{pi}{character vector name of study principal investigator}

\item{presDate}{presentation date (i.e. 17NOV2023) for DSMB}

\item{cutDate}{recent cutoff date for AEs (i.e. 31AUG2023)}

\item{boundDate}{lower bound cutoff date for AEs (if provided)}

\item{subjID}{key identifier field for participant ID in data sets}

\item{subjID_ineligText}{character text that denotes participant IDs to exclude.
For example, c("New Subject") (if provided)}

\item{baseline_datasets}{list of data frames that contain baseline participant characteristics.
For example, list(enrollment_DF,demography_DF,ineligibility_DF)}

\item{ae_dataset}{data frame that contains subject AEs}

\item{ineligVar}{field that denotes participant ineligibility (if provided)}

\item{ineligVarText}{character text that denotes participant ineligibility.
For example, c("Yes", "Y") (if provided)}

\item{genderVar}{field that denotes participant gender}

\item{enrolDtVar}{field that denotes participant enrollment date (i.e. 10MAY2021)}

\item{ae_detailVar}{field that denotes participant AE detail (lowest level term)}

\item{ae_categoryVar}{field that denotes participant AE category (system organ class)}

\item{ae_severityVar}{field that denotes participant AE severity grade (numeric)}

\item{ae_onsetDtVar}{field that denotes participant AE onset date}

\item{ae_detailOtherText}{character text that denotes referencing verbatim AE field.
For example, c("Other, specify", "OTHER") (if provided)}

\item{ae_detailOtherVar}{field that denotes participant AE detail other (if provided)}

\item{ae_verbatimVar}{field that denotes participant AE detail verbatim (if provided)}

\item{ae_attribVars}{field(s) that denotes attribution to intervention under study. \cr
For example, c("CTC_AE_ATTR_SCALE","CTC_AE_ATTR_SCALE_1") (if provided)}

\item{ae_attribVarsName}{character text that denotes name of interventions under study.
For example, c("Drug 1", "Drug 2") (if provided)}

\item{ae_attribVarText}{character text that denotes related attribution. For example
c("Definite", "Probable", "Possible") (if provided)}

\item{related_ae}{boolean that denotes if summary is for related AEs. Default is False.}

\item{numSubj}{vector to override value for number of participants in summary (if provided)}

\item{fileNameUnderscore}{boolean that denotes if spaces should be underscore in filename}
}
\value{
three Excel files containing DSMB-CCRU AE summary tables
}
\description{
Outputs the DSMB-DDP AE summary tables in Excel format per UHN template
}
\examples{
data("enrollment", "demography", "ineligibility", "ae");
dsmb_ddp(protocol="EXAMPLE_STUDY",setwd="./man/tables/",
  title="Phase X Study to Evaluate Treatments A-D",
  comp="COHORT",pi="Dr. Principal Investigator",
  presDate="30OCT2020",cutDate="31AUG2020",
  boundDate=NULL,subjID="Subject",subjID_ineligText=c("New Subject","Test"),
  baseline_datasets=list(enrollment,demography,ineligibility),
  ae_dataset=ae,ineligVar="INELIGIBILITY_STATUS",ineligVarText=c("Yes","Y"),
  genderVar="GENDER_CODE",enrolDtVar="ENROL_DATE_INT",ae_detailVar="ae_detail",
  ae_categoryVar="ae_category",ae_severityVar="AE_SEV_GD",
  ae_onsetDtVar="AE_ONSET_DT_INT",ae_detailOtherText="Other, specify",
  ae_detailOtherVar="CTCAE5_LLT_NM",ae_verbatimVar="AE_VERBATIM_TRM_TXT",
  ae_attribVars=c("CTC_AE_ATTR_SCALE","CTC_AE_ATTR_SCALE_1"),
  ae_attribVarsName=c("Drug 1","Drug 2"),
  ae_attribVarText=c("Definite", "Probable", "Possible"),
  numSubj=c(4,4,3,4))
}
\keyword{dataframe}
