/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.OrRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RealDifferencesToSimplexTransform
extends Transform.MultivariateTransform {
    private Parameter weights;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String WEIGHTS = "weights";
        public static final String DIMENSION = "dimension";
        public static final String REAL_DIFFERENCES_TO_SIMPLEX_TRANSFORM = "realDifferencesToSimplexTransform";

        @Override
        public Class getReturnType() {
            return RealDifferencesToSimplexTransform.class;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            if (xMLObject.hasChildNamed(WEIGHTS)) {
                Parameter parameter = (Parameter)xMLObject.getElementFirstChild(WEIGHTS);
                return new RealDifferencesToSimplexTransform(parameter.getDimension() - 1, parameter);
            }
            if (xMLObject.hasAttribute(DIMENSION)) {
                int n = xMLObject.getIntegerAttribute(DIMENSION);
                return new RealDifferencesToSimplexTransform(n);
            }
            throw new XMLParseException("RealDifferencesToSimplex must have either a dimension attribute ora set of weights");
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new OrRule(AttributeRule.newDoubleRule(DIMENSION), new ElementRule(WEIGHTS, Parameter.class))};
        }

        @Override
        public String getParserDescription() {
            return "Transform from a (n-1)-dimensional vector of positive real numbers to a n-dimensional weighted simplex";
        }

        @Override
        public String getParserName() {
            return REAL_DIFFERENCES_TO_SIMPLEX_TRANSFORM;
        }
    };

    public RealDifferencesToSimplexTransform(int n, Parameter parameter) {
        super(n);
        this.weights = parameter;
    }

    public RealDifferencesToSimplexTransform(int n) {
        super(n);
        this.weights = new Parameter.Default(n, 1.0 / (double)n);
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getTransformName() {
        return "realDifferencesToSimplex";
    }

    @Override
    protected double[] transform(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length + 1];
        double d = 0.0;
        for (n = 0; n <= this.dim; ++n) {
            double d2 = 0.0;
            for (int i = 0; i <= n; ++i) {
                if (i < this.dim) {
                    d2 += dArray[i];
                    continue;
                }
                d2 += 1.0;
            }
            d += d2 * this.weights.getParameterValue(n);
        }
        for (n = 0; n < this.dim; ++n) {
            if (n == 0) {
                dArray2[n] = dArray[n] / d;
                continue;
            }
            if (n >= this.dim) continue;
            dArray2[n] = (dArray2[n - 1] * d + dArray[n]) / d;
        }
        double d3 = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d3 += dArray2[i] * this.weights.getParameterValue(i);
        }
        dArray2[this.dim] = (1.0 - d3) / this.weights.getParameterValue(this.dim);
        return dArray2;
    }

    @Override
    protected double[] inverse(double[] dArray) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        int n;
        Matrix matrix = new Matrix(this.dim, this.dim);
        double d = 0.0;
        for (int i = 0; i <= this.dim; ++i) {
            double d2 = 0.0;
            for (n = 0; n <= i; ++n) {
                if (n < this.dim) {
                    d2 += dArray[n];
                    continue;
                }
                d2 += 1.0;
            }
            d += d2 * this.weights.getParameterValue(i);
        }
        double d3 = d * d;
        for (int i = 0; i < this.dim; ++i) {
            for (n = 0; n < this.dim; ++n) {
                double d4 = 0.0;
                for (int j = n; j <= this.dim; ++j) {
                    d4 += this.weights.getParameterValue(j);
                }
                double d5 = 0.0;
                for (int j = 0; j < i + 1; ++j) {
                    d5 += dArray[j];
                }
                if (n <= i) {
                    matrix.set(i, n, (d - d4 * d5) / d3);
                    continue;
                }
                matrix.set(i, n, -d4 * d5 / d3);
            }
        }
        double d6 = 0.0;
        try {
            d6 = Math.log(Math.abs(matrix.determinant()));
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        return d6;
    }

    @Override
    protected double[] getGradientLogJacobianInverse(double[] dArray) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected boolean isInInteriorDomain(double[] dArray) {
        throw new RuntimeException("not implemented");
    }
}

