/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.ReadableMatrix;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WritableMatrix;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class CachedMatrixInverse
extends CompoundParameter
implements MatrixParameterInterface {
    private final MatrixParameterInterface base;
    private final int dim;
    private boolean inverseKnown;
    private boolean savedInverseKnown;
    private WrappedMatrix inverse;
    private WrappedMatrix savedInverse;
    private static final boolean EMJL = true;
    private static final boolean DEBUG = false;

    public CachedMatrixInverse(String string, MatrixParameterInterface matrixParameterInterface) {
        super(string, new Parameter[]{matrixParameterInterface});
        assert (matrixParameterInterface.getColumnDimension() == matrixParameterInterface.getRowDimension());
        this.base = matrixParameterInterface;
        this.dim = matrixParameterInterface.getColumnDimension();
    }

    @Override
    public int getDimension() {
        return this.dim * this.dim;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        this.checkInverse();
        return this.inverse.get(n, n2);
    }

    @Override
    public double getParameterValue(int n) {
        return this.getParameterValue(n / this.dim, n % this.dim);
    }

    @Override
    public double[][] getParameterAsMatrix() {
        double[][] dArray = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                dArray[i][j] = this.getParameterValue(i, j);
            }
        }
        return dArray;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.base) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.inverseKnown = false;
        this.fireParameterChangedEvent(n, changeType);
    }

    private void computeInverse() {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.base.getParameterAsMatrix());
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.getColumnDimension(), this.getColumnDimension());
        CommonOps.invert(denseMatrix64F, denseMatrix64F2);
        this.inverse = new WrappedMatrix.WrappedDenseMatrix(denseMatrix64F2);
    }

    private void checkInverse() {
        if (!this.inverseKnown) {
            this.computeInverse();
            this.inverseKnown = true;
        }
    }

    public void forceComputeInverse() {
        this.computeInverse();
        this.inverseKnown = true;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }

    @Override
    public int getUniqueParameterCount() {
        return 1;
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return this.base;
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String toSymmetricString() {
        return MatrixParameter.toSymmetricString(this);
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Do not set entries directly");
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Do not set entries directly");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        throw new RuntimeException("Do not set entries directly");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        throw new RuntimeException("Do not set entries directly");
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        throw new RuntimeException("Do not set entries directly");
    }

    @Override
    public double[] getColumnValues(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = this.getColumnDimension();
        String string = Integer.toString(n / n2);
        String string2 = Integer.toString(n % n2);
        return this.getId() + string + string2;
    }

    @Override
    protected void storeValues() {
        super.storeValues();
        this.savedInverseKnown = this.inverseKnown;
        if (this.inverse != null) {
            if (this.savedInverse == null) {
                this.savedInverse = new WrappedMatrix.WrappedDenseMatrix(new DenseMatrix64F(this.dim, this.dim));
            }
            CachedMatrixInverse.copy(this.inverse, this.savedInverse);
        }
    }

    @Override
    protected void restoreValues() {
        super.restoreValues();
        this.inverseKnown = this.savedInverseKnown;
        WrappedMatrix wrappedMatrix = this.inverse;
        this.inverse = this.savedInverse;
        this.savedInverse = wrappedMatrix;
    }

    static void copy(ReadableMatrix readableMatrix, WritableMatrix writableMatrix) {
        assert (readableMatrix.getDim() == writableMatrix.getDim());
        int n = readableMatrix.getDim();
        for (int i = 0; i < n; ++i) {
            writableMatrix.set(i, readableMatrix.get(i));
        }
    }

    @Override
    public String getReport() {
        return new WrappedMatrix.ArrayOfArray(this.getParameterAsMatrix()).toString();
    }

    public MatrixParameterInterface getBaseParameter() {
        return this.base;
    }
}

