/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchratemodel.CountableBranchCategoryProvider;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LineageSpecificBranchModel
extends AbstractModel
implements BranchModel,
Citable {
    public static final String LINEAGE_SPECIFIC_BRANCH_MODEL = "lineageSpecificBranchModel";
    private static final boolean DEBUG = false;
    private boolean setupMapping = true;
    private Map<NodeRef, BranchModel.Mapping> nodeMap;
    private List<SubstitutionModel> substitutionModels;
    private TreeModel treeModel;
    private FrequencyModel rootFrequencyModel;
    private CountableBranchCategoryProvider categoriesProvider;
    private Parameter categoriesParameter;

    public LineageSpecificBranchModel(TreeModel treeModel, FrequencyModel frequencyModel, List<SubstitutionModel> list, Parameter parameter) {
        super("");
        this.treeModel = treeModel;
        this.substitutionModels = list;
        this.categoriesParameter = parameter;
        this.rootFrequencyModel = frequencyModel;
        this.categoriesProvider = new CountableBranchCategoryProvider.IndependentBranchCategoryModel(treeModel, parameter);
        this.nodeMap = new HashMap<NodeRef, BranchModel.Mapping>();
        for (SubstitutionModel substitutionModel : this.substitutionModels) {
            this.addModel(substitutionModel);
        }
        this.addModel(this.treeModel);
        this.addModel(this.rootFrequencyModel);
        this.addModel((Model)((Object)this.categoriesProvider));
        this.addVariable(this.categoriesParameter);
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        if (this.setupMapping) {
            this.setupNodeMap(nodeRef);
        }
        return this.nodeMap.get(nodeRef);
    }

    private void setupNodeMap(NodeRef nodeRef) {
        if (nodeRef != this.treeModel.getRoot()) {
            int n = this.categoriesProvider.getBranchCategory(this.treeModel, nodeRef);
            final int n2 = (int)this.categoriesParameter.getParameterValue(n);
            this.nodeMap.put(nodeRef, new BranchModel.Mapping(){

                @Override
                public int[] getOrder() {
                    return new int[]{n2};
                }

                @Override
                public double[] getWeights() {
                    return new double[]{1.0};
                }
            });
        }
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModels;
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        throw new RuntimeException("This method should never be called!");
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.rootFrequencyModel;
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
        this.setupMapping = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MOLECULAR_CLOCK;
    }

    @Override
    public String getDescription() {
        return "Lineage Specific Branch model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(new Citation(new Author[]{new Author("F", "Bielejec"), new Author("P", "Lemey"), new Author("G", "Baele"), new Author("A", "Rambaut"), new Author("MA", "Suchard")}, Citation.Status.IN_PREPARATION));
    }
}

