/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel.lineagespecific;

import dr.evomodel.branchmodel.lineagespecific.CountableRealizationsParameter;
import dr.evomodel.branchratemodel.CountableBranchCategoryProvider;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treelikelihood.BeagleTreeLikelihood;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.CompoundModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BranchLikelihood
implements Likelihood {
    private TreeModel treeModel;
    private BeagleTreeLikelihood likelihood;
    private CountableBranchCategoryProvider categoriesProvider;
    private Parameter categoriesParameter;
    private CompoundParameter uniqueParameters;
    private CountableRealizationsParameter allParameters;
    private final CompoundModel compoundModel = new CompoundModel("compoundModel");

    public BranchLikelihood(TreeModel treeModel, BeagleTreeLikelihood beagleTreeLikelihood, Parameter parameter, CompoundParameter compoundParameter, CountableRealizationsParameter countableRealizationsParameter) {
        this.treeModel = treeModel;
        this.categoriesParameter = parameter;
        this.uniqueParameters = compoundParameter;
        this.allParameters = countableRealizationsParameter;
        this.categoriesProvider = new CountableBranchCategoryProvider.IndependentBranchCategoryModel(this.treeModel, parameter);
    }

    @Override
    public double getLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.categoriesParameter.getDimension(); ++i) {
            int n = (int)this.categoriesParameter.getParameterValue(i);
            double d2 = this.uniqueParameters.getParameterValue(n);
            this.allParameters.setParameterValue(i, d2);
        }
        this.likelihood.makeDirty();
        d = this.likelihood.getLogLikelihood();
        return d;
    }

    public double getLogLikelihood(int n) {
        double d = this.likelihood.getLogLikelihood();
        int n2 = (int)this.categoriesParameter.getParameterValue(n);
        double d2 = this.uniqueParameters.getParameterValue(n2);
        this.allParameters.setParameterValue(n, d2);
        this.likelihood.makeDirty();
        double d3 = this.likelihood.getLogLikelihood();
        return d3 - d;
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId() == null ? "likelihood" : this.getId())};
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public void setId(String string) {
    }

    @Override
    public Model getModel() {
        return this.compoundModel;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        return new HashSet<Likelihood>(Arrays.asList(this));
    }

    @Override
    public boolean isUsed() {
        return true;
    }

    @Override
    public void setUsed() {
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    private class LikelihoodColumn
    extends NumberColumn {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return BranchLikelihood.this.getLogLikelihood();
        }
    }
}

