/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.util;

import dr.evolution.util.Date;
import dr.evolution.util.Location;
import dr.evolution.util.TimeScale;
import dr.util.Attributable;
import dr.util.Identifiable;
import java.util.ArrayList;
import java.util.Iterator;

public class Taxon
implements Attributable,
Identifiable,
Comparable<Taxon> {
    private Attributable.AttributeHelper attributes = null;
    protected String id = null;
    private static Date mostRecentDate = null;
    private static TimeScale timeScale = null;

    public Taxon(String string) {
        this.setId(string);
    }

    public void setDate(Date date) {
        this.setAttribute("date", date);
        Taxon.addDateToTimeScale(date);
    }

    public Date getDate() {
        Object object = this.getAttribute("date");
        if (object != null && object instanceof Date) {
            return (Date)object;
        }
        return null;
    }

    public double getHeight() {
        Object object = this.getAttribute("date");
        if (object != null && object instanceof Date) {
            return Taxon.getHeightFromDate((Date)object);
        }
        return 0.0;
    }

    public void setLocation(Location location) {
        this.setAttribute("location", location);
    }

    public Location getLocation() {
        Object object = this.getAttribute("location");
        if (object != null && object instanceof Location) {
            return (Location)object;
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    public boolean containsAttribute(String string) {
        return this.attributes != null && this.attributes.containsAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return new ArrayList().iterator();
        }
        return this.attributes.getAttributeNames();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object object) {
        return this.getId().equals(((Taxon)object).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(Taxon taxon) {
        return this.getId().compareTo(taxon.getId());
    }

    private static void addDateToTimeScale(Date date) {
        if (date != null && (mostRecentDate == null || date.after(mostRecentDate))) {
            mostRecentDate = date;
            timeScale = null;
        }
    }

    public static double getHeightFromDate(Date date) {
        if (timeScale == null) {
            Date date2 = mostRecentDate;
            if (date2 == null) {
                date2 = Date.createRelativeAge(0.0, date.getUnits());
            }
            timeScale = new TimeScale(date2.getUnits(), true, date2.getAbsoluteTimeValue());
        }
        return timeScale.convertTime(date.getTimeValue(), date);
    }

    public static Date getMostRecentDate() {
        return mostRecentDate;
    }
}

