% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest.R
\name{backtest}
\alias{backtest}
\title{Backtesting via Value-at-Risk (VaR)}
\usage{
backtest(
  x,
  window_length = 1000,
  p = 0.99,
  portfolio_weights = NULL,
  n.ahead = 1,
  distribution = "empirical",
  nc = 1
)
}
\arguments{
\item{x}{An object of class "bekkFit" from the function \link{bekk_fit}.}

\item{window_length}{An integer specifying the length of the rolling window.}

\item{p}{A numerical value that determines the confidence level. The default value is set at 0.99 in accordance with the Basel Regulation.}

\item{portfolio_weights}{A vector determining the portfolio weights to calculate the portfolio VaR. If set to "NULL", the univariate VaR for each series are calculated.}

\item{n.ahead}{Number of periods to predict conditional volatility. Default is a one-period ahead forecast.}

\item{distribution}{A character string determining the assumed distribution of the residuals. Implemented are "normal", "empirical" and "t". The default is assuming the empirical distribution of the residuals.}

\item{nc}{Number of cores to be used for parallel computation.}
}
\value{
Returns a S3 class "backtest" object containing the VaR forecast, out-of-sample returns and backtest statistics according to the R-package "GAS". conf
}
\description{
Method for backtesting a model obtained from \link{bekk_fit} in terms of VaR-forcasting accuracy using a rolling window approach.
}
\examples{
\donttest{

data(StocksBonds)
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

# backtesting
x2 <- backtest(x1, window_length = 6000, n.ahead = 1, nc = 1)
plot(x2)
# backtesting using 5 day-ahead forecasts
x3 <- backtest(x1, window_length = 6000, n.ahead = 5, nc = 1)
plot(x3)
# backtesting using 20 day-ahead forecasts and portfolio
x4 <- backtest(x1, window_length = 6000, portfolio_weights = c(0.5,0.5), n.ahead = 20, nc = 1)
plot(x4)
}

}
