% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportCSV.R
\name{read_oxcal}
\alias{read_oxcal}
\title{Read MCMC output from OxCal}
\usage{
read_oxcal(file, quiet = "no")
}
\arguments{
\item{file}{Either a path to a CSV file, a connection,
or the value \code{clipboard()} to read from the system clipboard.
The CSV file can be compressed or plain.
See \code{\link[readr]{read_csv}} for details.}

\item{quiet}{One of "no" (default) to allow messages and warnings, "partial"
to suppress messages and allow warnings, or "yes" to suppress messages
and warnings.}
}
\value{
An \code{archaeophases_mcmc} object containing the marginal
posterior(s) as a data frame.
}
\description{
Import a CSV file containing the output of the MCMC algorithm produced
by \href{https://c14.arch.ox.ac.uk/oxcal.html}{OxCal}.
}
\details{
The \code{read_oxcal} function is built on \code{\link[readr]{read_csv}}.
It aims to be fast and simple, and to return the marginal posteriors free
of extraneous artifacts.  The iteration column in the CSV file is discarded,
as is an empty last column.
}
\examples{

\dontrun{
  # Import of MCMC output from OxCal
  data(Events)
  #To do for saving in csv file
  # write.csv(Events, "events.csv", row.names = FALSE)
  fishpond <- read_oxcal("events.csv")

  # Read from connection
  oxc <- read_oxcal("http://tsdye.online/AP/ox.csv")
}

}
\seealso{
\code{\link[readr]{read_csv}}

\code{\link{ImportCSV}}
}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
