% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OccurrencePlot.R
\name{OccurrencePlot}
\alias{OccurrencePlot}
\title{Plot occurrences}
\usage{
OccurrencePlot(
  data,
  position,
  plot.result = NULL,
  level = 0.95,
  intervals = "CI",
  title = "Occurrence plot",
  subtitle = NULL,
  caption = "ArchaeoPhases",
  labelXaxis = "Calendar year",
  labelYaxis = NULL,
  language = "English",
  occurrence = "occurrence",
  height = 7,
  width = 7,
  units = "in",
  x.min = NULL,
  x.max = NULL,
  x.scale = "calendar",
  elapsed.origin.position = NULL,
  dumbbell.size = 1,
  dot.guide = FALSE,
  dot.guide.size = 0.25,
  y.grid = FALSE,
  file = NULL,
  newWindow = TRUE,
  print.data.result = FALSE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{plot.result}{If \code{TRUE}, then draw a plot on the display,
else suppress drawing.}

\item{level}{Probability corresponding to the level of confidence.}

\item{intervals}{One of "CI" for credible intervals or
"HPD" for highest posterior density intervals.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{labelXaxis}{Label of the x-axis.}

\item{labelYaxis}{Label of the y-axis.}

\item{language}{String indicating a language recognized by the
\pkg{toOrdinal} package.}

\item{occurrence}{String to append to each y-axis tic label.}

\item{height}{Plot height in \code{units}.}

\item{width}{Plot width in \code{units}.}

\item{units}{String recognized by the \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{x.min}{Minimum x-axis value.}

\item{x.max}{Maximum x-axis value.}

\item{x.scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for time elapsed from a specified origin.}

\item{elapsed.origin.position}{Position of the column to use
as the origin for elapsed time calculations.}

\item{dumbbell.size}{Size of the plot symbol.}

\item{dot.guide}{Switch for a horizontal guide from the y axis.}

\item{dot.guide.size}{Size of the dot guide.}

\item{y.grid}{Switch for horizontal grid lines.}

\item{file}{Name of the file that will be saved if specified.
If \code{NULL} no plot will be saved.}

\item{newWindow}{Whether or not the plot is drawn within a new window.}

\item{print.data.result}{If \code{TRUE}, the list containing the data
to plot will be returned.}
}
\value{
\code{NULL}, called for its side effects. It may also return
a list containing the data to plot (if \code{print.data.result = TRUE}).
}
\description{
A statistical graphic designed for the archaeological study of when
events of a specified kind occurred
}
\details{
If we have k events, then we can estimate the calendar date t corresponding to the
smallest date such that the number of events observed before t is equal to k.
The \code{OccurrencePlot()} estimates these occurrences and gives the credible
interval or the highest posterior density (HPD) region with a desired level of confidence.
}
\examples{
  data(Events);
  OccurrencePlot(Events[1:1000, ], c(2:5),  print.data.result = FALSE)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
