% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalStatistics.R
\name{multi_marginal_statistics}
\alias{multi_marginal_statistics}
\title{Marginal summary statistics for multiple MCMC chains}
\usage{
multi_marginal_statistics(
  data,
  position = 1:ncol(data),
  level = 0.95,
  round_to = 0
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the positions of the columns
corresponding to the MCMC chains of interest, or a vector of column
names.}

\item{level}{Probability corresponding to the level of confidence
used for the credible interval and the highest posterior density region.}

\item{round_to}{Integer indicating the number of decimal places.}
}
\value{
A data frame where the rows correspond to the chains of interest and
columns to the following statistics:
\describe{
\item{mean}{The mean of the MCMC chain.}
\item{sd}{The standard deviation of the MCMC chain.}
\item{min}{Minimum value of the MCMC chain;}
\item{q1}{First quantile of the MCMC chain;}
\item{median}{Median of the MCMC chain;}
\item{q3}{Third quantile of the MCMC chain; and}
\item{max}{Maximum value of the MCMC chain.}
\item{ci.inf}{Lower credible interval of the MCMC chain at \code{level}.}
\item{ci.sup}{Upper credible interval of the MCMC chain at \code{level}.}
}
}
\description{
Calculates summary statistics of the output of the MCMC algorithm for
multiple parameters. Results are given in calendar years (BC/AD).
}
\examples{
  data(Events)
  multi_marginal_statistics(Events, 2:5)
  multi_marginal_statistics(Events, 2:5, level = 0.90)
  ## round to decades
  multi_marginal_statistics(Events, 2:5, round_to = -1)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}, and

Thomas S. Dye, \email{tsd@tsdye.online}
}
