% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiHPD.R
\name{multi_hpd}
\alias{multi_hpd}
\title{Bayesian HPD regions for a series of MCMC chains}
\usage{
multi_hpd(data, position, level = 0.95, round_to = 0)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{level}{Probability corresponding to the level of confidence.}

\item{round_to}{Integer indicating the number of decimal places.}
}
\value{
Returns a list with the following components:
\describe{
\item{results}{A data frame where the rows correspond to the columns
in the selected data set and the columns labeled \code{inf} and \code{sup}
correspond to the lower and upper endpoints of each highest posterior
density interval, respectively.}
\item{level}{Probability corresponding to the level of confidence.}
\item{call}{The function call.}
}
matrix of values containing the level of confidence
and  for each variable of the MCMC chain.
The name of the resulting rows are the positions of the corresponding
columns in the CSV file. The result is given in calendar years (BC/AD).
}
\description{
Estimation of the highest posterior density regions for each variable of a
simulated Markov chain. This function uses the \code{hdr()} function
included in the \pkg{hdrcde} package. An HPD region may be a union of
several intervals.
}
\details{
Highest posterior density function region using the function
\code{hdr()} from the \pkg{hdrcd} package
}
\examples{
  data(Events)
  multi_hpd(Events, c(2, 4, 3), 0.95)

}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density regions.
American Statistician, 50, 120-126.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
