% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllenExpect.R
\name{allen_observe_frequency}
\alias{allen_observe_frequency}
\title{Observed frequency of an Allen set}
\usage{
allen_observe_frequency(mcmc, chains, allen_set)
}
\arguments{
\item{mcmc}{Dataframe or archaeophases_mcmc object with the MCMC output
from a Bayesian calibration.}

\item{chains}{a list of vectors of names or indexes of columns in \code{mcmc}.}

\item{allen_set}{A string representation of an Allen set.}
}
\value{
A matrix of observed frequencies.
}
\description{
Create a matrix of observed frequencies of a given
Allen set among two or more groups of chains from
the MCMC output of a Bayesian calibration.  The
groups are permuted to form the matrix.
}
\examples{

\dontrun{
# Dates associated with bead BE3 Amber
be3.amber <- c("UB-4836 (WG27)", "UB-5208 (ApD107)", "UB-4965 (ApD117)",
"UB-4735 (Ber022)", "UB-4739 (Ber134/1)", "UB-4728 (MH064)",
"UB-4729 (MH068)", "UB-4732 (MH094)", "UB-4733 (MH095)", "UB-4734 (MH105c)",
"UB-4984 (Lec018)", "UB-4709 (EH014)", "UB-4707 (EH079)", "UB-4708 (EH083)",
"UB-6033 (WHes113)", "UB-4706 (WHes118)", "UB-4705 (WHes123)",
"UB-6040 (CasD053)", "UB-6037 (CasD134)", "UB-6472 (BuD222)",
"UB-6473 (BuD250)", "UB-6476 (BuD339)", "UB-4963 (SPTip208)",
"UB-4890 (MelSG075)", "UB-4887 (MelSG082)", "UB-4888 (MelSG089)",
"MaDE1 & E2", "UB-4552 (MaDE3)", "UB-4975 (AstCli12)", "UB-4835 (ApD134)",
"SUERC-39108 ERLK G322", "SUERC-39109 ERL G362", "SUERC-39112 ERL G405",
"SUERC-51560 ERL G038", "SUERC-39091 (ERL G003)", "SUERC-39092 (ERL G005)",
"SUERC-39113 (ERL G417)", "SUERC-51549 (ERL G195)", "SUERC-51552 (ERL G107)",
"SUERC-51550 (ERL G254)")

# Dates associated with bead BE1 Dghnt
be1.dghnt <- c("UB-4503 (Lec148)", "UB-4506 (Lec172/2)",
"UB-6038 (CasD183)", "UB-4512 (EH091)", "UB-4501 (Lec014)",
"UB-4507 (Lec187)", "UB-4502 (Lec138)", "UB-4042 (But1674)",
"SUERC-39100 (ERL G266)")

# Construct a list of vectors
chains <- list("BE3-Amber" = be3.amber, "BE1-Dghnt" = be1.dghnt)

# Read the calibration MCMC output
oxc <- read_oxcal("https://tsdye.online/AP/beads-mcmc.csv", quiet = 'yes')

# Observe 2x2 frequency matrix of the relation of trunk to branch
# allen_observe(mcmc = oxc, chains = chains, allen_set = "oFD")
}

}
\author{
Thomas S. Dye
}
