% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalPlot.R
\name{MarginalPlot}
\alias{MarginalPlot}
\title{Plot a marginal posterior density}
\usage{
MarginalPlot(
  a_chain,
  level = 0.95,
  GridLength = 1024,
  title = "Characteristics of a date",
  subtitle = NULL,
  caption = "ArchaeoPhases",
  x.label = "Calendar year",
  y.label = NULL,
  y.grid = TRUE,
  x.scale = "calendar",
  elapsed.origin.position = NULL,
  x.min = NULL,
  x.max = NULL,
  height = 7,
  width = 7,
  units = "in",
  file = NULL,
  newWindow = TRUE
)
}
\arguments{
\item{a_chain}{Numeric vector containing the output of the MCMC algorithm
for the parameter.}

\item{level}{Probability corresponding to the level of confidence.}

\item{GridLength}{Length of the grid used to estimate the density.}

\item{title}{Title of the graph.}

\item{subtitle}{Subtitle of the graph.}

\item{caption}{Caption of the graph.}

\item{x.label}{Label of the x-axis.}

\item{y.label}{Label of the y-axis.}

\item{y.grid}{Switch for horizontal grid lines.}

\item{x.scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for time elapsed from a specified origin.}

\item{elapsed.origin.position}{Position of the column to use as the
origin for elapsed time calculations.}

\item{x.min}{Minimum x axis value.}

\item{x.max}{Maximum x axis value.}

\item{height}{Plot height in \code{units}.}

\item{width}{Plot width in \code{units}.}

\item{units}{String recognized by the \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{file}{Name of the file that will be saved if chosen, default = \code{NULL}.}

\item{newWindow}{Whether or not the plot is drawn within a new window.}
}
\value{
\code{NULL}, called for its side effects
}
\description{
Draws a plot of the estimated marginal posterior density for the one-parameter and adds the mean
and the credible interval at the desired level
}
\details{
The density is estimated using \code{density()} function with \code{n = GridLength}.
}
\examples{
  data(Events);
  MarginalPlot(a_chain = Events$Event.1, level = 0.95)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
