% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApotcIndexing.R
\name{containsApotcRun}
\alias{containsApotcRun}
\title{Check for the existence of an APackOfTheClones run with its run id}
\usage{
containsApotcRun(seurat_obj, run_id)
}
\arguments{
\item{seurat_obj}{a seurat object}

\item{run_id}{character. The id of the associated ApotcRun.}
}
\value{
A logical indicating whether the run exists.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A convenience function to check for the existence of an APackOfTheClones
run with its run id, regardless of if any run has been made
}
\examples{
pbmc <- RunAPOTC(
    seurat_obj = get(data("combined_pbmc")),
    reduction_base = "umap",
    clonecall = "strict",
    run_id = "run1",
    verbose = FALSE
)

containsApotcRun(pbmc, "run1")
#> [1] TRUE

containsApotcRun(pbmc, "run2")
#> [1] FALSE

}
