% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noether.R
\name{noether}
\alias{noether}
\title{Calculate Noether approximation}
\usage{
noether(p1, alpha = 0.05, power = 0.9)
}
\arguments{
\item{p1}{Probability (expressed as a number between 0 and 1)}

\item{alpha}{Level of significance (expressed as number between 0 and 1) (defaults to \code{0.05})}

\item{power}{Power (expressed as number between 0 and 1) (defaults to \code{0.9})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{noether()} calculates the Noether approximation and is used in chapter 5 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Exercise 5.8 from "Applied Nonparametric Statistical Methods" (5th edition)
noether(p1 = 0.7534, alpha = 0.05, power = 0.9)

# Exercise 5.16 from "Applied Nonparametric Statistical Methods" (5th edition)
noether(p1 = 0.8, alpha = 0.025, power = 0.9)

}
