#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Justyna Brzeziska     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(ca)         #zawiera funkcje do analizy korespondencji
library(faraway)    #zawiera zbir danych "debt"
library(vcd)        #zawiera funkcje liczce miary wspzalenoci
library(clusterSim) #w nim indeks sylwetkowy do taksonomii
options(OutDec=",")
data(debt)
dane<-debt
print("Zamiana nazw kategorii poszczeglnych zmiennych (z liczbowych na sowne):",quote=FALSE)
dane$incomegp[dane$incomegp=='1']<-'1.najniszy'
dane$incomegp[dane$incomegp=='2']<-'2.niski'
dane$incomegp[dane$incomegp=='3']<-'3.redni'
dane$incomegp[dane$incomegp==4]<-'4.wysoki'
dane$incomegp[dane$incomegp==5]<-'5.najwyszy'
print("Kategorie zmiennej incomegp:",quote=FALSE)
print(table(dane$incomegp))
dane$house[dane$house==1]<-'wynajty'
dane$house[dane$house==2]<-'kredyt'
dane$house[dane$house==3]<-'wasny'
print("Kategorie zmiennej house:",quote=FALSE)
print(table(dane$house))
attach(dane)
print("Budowa tablicy kontyngencji oraz weryfikowanie hipotezy o niezalenoci zmiennych:",quote=FALSE)
tablica.kontyngencji<-xtabs(~incomegp+house)
zaleznosc<-assocstats(tablica.kontyngencji)
print(tablica.kontyngencji)
print("Testowanie i miary zalenoci zmiennych:",quote=FALSE)
print(zaleznosc)
print("Przeprowadzenie zasadniczej czci analizy korespondencji:",quote=FALSE)
model.ca<-ca(tablica.kontyngencji)
print("W wyniku przeprowadzonej analizy korespondencji otrzymujemy:",quote=FALSE)
print(model.ca)
print("Podsumowanie wynikw analizy korespondencji w nieco innej, bardziej rozbudowanej postaci:",quote=FALSE)
summary(model.ca)
plot(model.ca, mass=c(TRUE, TRUE),contrib=c("absolute","absolute"),las=1) # Mapa percepcji
print("Przejcie wsprzdnych punktw z mapy percepcji w celu zrealizowania analizy taksonomicznej",quote=FALSE)
dane.do.taksonomii<-as.data.frame(0.001*rbind(summary(model.ca)$rows[,c(5,8)],summary(model.ca)$columns[,c(5,8)]))
print("a take przejcie etykiet punktw (kategorii) z mapy percepcji",quote=FALSE)
print("w wyniku tych zabiegw zbudowano zbir danych, ktry poddano analizie taksonomicznej:",quote=FALSE)
row.names(dane.do.taksonomii)<-c(model.ca$rownames,model.ca$colnames)
print(dane.do.taksonomii)
macierz.odlegoci<-dist(dane.do.taksonomii,method="euclidean")
getOption("device")() #otwarcie drugiego okienka graficznego na potrzeby drugiego wykresu
model.taks<-hclust(macierz.odlegoci,method="ward")
plot(model.taks,labels=row.names(dane.do.taksonomii),main="",sub="",xlab="",ylab="Poziom poczenia klas",las=1)
detach(dane)