% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoomgrid.R
\docType{package}
\name{zoomgrid-package}
\alias{zoomgrid}
\alias{zoomgrid-package}
\title{zoomgrid: grid search with zoom-in layers}
\description{
The \pkg{zoomgrid} package implements a grid search algorithm with optional zoom-in layers.
The method is intended for objective functions with multiple local optima, where standard
optimisation routines may be sensitive to initial values.
}
\details{
\strong{Core idea.} A standard grid search proceeds as follows:
\enumerate{
  \item Construct a grid of candidate points over a bounded parameter domain.
  \item Evaluate the objective function at each grid point.
  \item Return the best point(s) found on the grid (for minimisation or maximisation).
}

A sufficiently fine grid may yield a good approximation to the global optimum, but the number
of grid points grows quickly with dimension, making exhaustive evaluation expensive.

\strong{Zoom-in layers.} To reduce computational cost, \pkg{zoomgrid} provides an optional
zoom-in mechanism. After an initial grid search, the algorithm selects the best \eqn{n}
points (controlled by \code{num}) and constructs smaller subgrids around those points.
This procedure is repeated for \eqn{k} additional layers (controlled by \code{zoom}).
At each layer, subgrid sizes shrink according to the decay rate \code{decay}, which allows
the algorithm to concentrate evaluations in promising neighbourhoods while keeping the total
number of function evaluations manageable.

In typical use, the method serves one of the following purposes:
\itemize{
  \item provide suitable initial values for subsequent optimisation,
  \item or approximate the optimiser when a very fine one-shot grid is impractical.
}

\strong{Parallel evaluation.} Function evaluations can be parallelised by setting
\code{parallel = TRUE}. Parallel execution is implemented via the \pkg{future} framework
using a cross-platform backend. The packages \pkg{future} and \pkg{future.apply} are listed
under \sQuote{Suggests} and are required only when parallel execution is requested.
}
\section{Author and Maintainer}{

Yukai Yang

Department of Statistics, Uppsala University

\email{yukai.yang@statistik.uu.se}
}

\section{References}{

Yang, Y. (2012). \emph{Modelling Nonlinear Vector Economic Time Series}. PhD thesis,
Aarhus University, Department of Economics and Business and CREATES. See Section 1.5.4.
}

\section{Main functions}{

\itemize{
  \item \code{\link{build_grid}}: construct a grid over the parameter domain.
  \item \code{\link{grid_search}}: perform grid search with optional zoom-in layers.
  \item \code{\link{grid_search_check}}: estimate runtime under given settings.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/yukai-yang/zoomgrid}
  \item Report bugs at \url{https://github.com/yukai-yang/zoomgrid/issues}
}

}
\author{
\strong{Maintainer}: Yukai Yang \email{yukai.yang@statistik.uu.se} (\href{https://orcid.org/0000-0002-2623-8549}{ORCID})

}
\keyword{internal}
