% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalSampler.R
\name{MarginalSampler}
\alias{MarginalSampler}
\title{Marginal Sampler Base Class}
\description{
Abstract base class for marginal sampling strategies that do not
condition on other features. Marginal samplers sample from P(X_S), the marginal
distribution of features S, ignoring any dependencies with other features.
}
\details{
This class provides a common interface for different marginal sampling approaches:
\itemize{
\item \strong{MarginalPermutationSampler}: Shuffles features independently within the dataset
\item \strong{MarginalReferenceSampler}: Samples complete rows from reference data
}

Both approaches sample from the marginal distribution P(X_S), but differ in how
they preserve or break within-row dependencies:
\itemize{
\item Permutation breaks ALL dependencies (both with target and between features)
\item Reference sampling preserves WITHIN-row dependencies but breaks dependencies with test data
}

\strong{Comparison with ConditionalSampler:}
\itemize{
\item \code{MarginalSampler}: Samples from \eqn{P(X_S)} - no conditioning
\item \code{ConditionalSampler}: Samples from \eqn{P(X_S | X_{-S})}- conditions on other features
}

This base class implements the public \verb{$sample()} and \verb{$sample_newdata()} methods,
delegating to private \code{.sample_marginal()} which subclasses must implement.
}
\section{Super class}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{MarginalSampler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MarginalSampler-sample}{\code{MarginalSampler$sample()}}
\item \href{#method-MarginalSampler-sample_newdata}{\code{MarginalSampler$sample_newdata()}}
\item \href{#method-MarginalSampler-clone}{\code{MarginalSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="initialize"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-initialize'><code>xplainfi::FeatureSampler$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalSampler-sample"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalSampler-sample}{}}}
\subsection{Method \code{sample()}}{
Sample features from their marginal distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalSampler$sample(feature, row_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{(\code{character()}) Feature name(s) to sample.}

\item{\code{row_ids}}{(\code{integer()} | \code{NULL}) Row IDs from task to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified copy with sampled feature(s).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalSampler-sample_newdata"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalSampler-sample_newdata}{}}}
\subsection{Method \code{sample_newdata()}}{
Sample from external data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalSampler$sample_newdata(feature, newdata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{(\code{character()}) Feature(s) to sample.}

\item{\code{newdata}}{(\code{\link[data.table:data.table]{data.table}}) External data to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified copy with sampled feature(s).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
