% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edu_group_sum.R
\name{edu_group_sum}
\alias{edu_group_sum}
\title{Education group sums}
\usage{
edu_group_sum(
  d = NULL,
  n = 4,
  strip_totals = TRUE,
  factor_convert = TRUE,
  year_edu_start = 2020
)
}
\arguments{
\item{d}{Data frame downloaded from the}

\item{n}{Number of education groups (from 4, 6 or 8)}

\item{strip_totals}{Remove total sums in \code{epop} column. Will not strip education totals if \code{year < year_edu_start} and \code{n = 8} as past data on population size by 8 education groups is unavailable.}

\item{factor_convert}{Convert columns that are character strings to factors, with levels based on order of appearance.}

\item{year_edu_start}{Year in which education splits are available for given groupings - in some versions past data is not available for some education groupings. Set to 2020 by default.}
}
\value{
A tibble with the data selected.
}
\description{
Cleans \code{epop} data, downloaded using the \code{wcde()} function, for summations of population by 4, 6 or 8 education groups.
}
\details{
Strips the \code{epop} data set to relevant rows for the \code{n} education groups.
}
\examples{
library(tidyverse)
past_epop \%>\%
  filter(year == 2020) \%>\%
  edu_group_sum()
}
