% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_global_importance.R
\name{plot.global_importance}
\alias{plot.global_importance}
\title{Plot Global Variable Importance measure}
\usage{
\method{plot}{global_importance}(x, ..., variables = NULL, type = NULL, title = "Variable importance")
}
\arguments{
\item{x}{object returned from \code{global_variable_importance()} function}

\item{...}{other object returned from \code{global_variable_importance()} function that shall be plotted together}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}

\item{type}{a character. How variables shall be plotted? Either "bars" (default) or "lines".}

\item{title}{the plot's title, by default \code{'Variable importance'}}
}
\value{
a ggplot2 object
}
\description{
Function plot.global_importance plots global importance measure based on Partial Dependence profiles.
}
\examples{

library("DALEX")
data(apartments)

library("randomForest")
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface +
                                    floor + no.rooms, data = apartments)

explainer_rf <- explain(apartments_rf_model, data = apartmentsTest[,2:5],
                        y = apartmentsTest$m2.price)

profiles <- model_profile(explainer_rf)

library("vivo")
measure <- global_variable_importance(profiles)

plot(measure)


}
