% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_model.R
\name{run_lightgbm}
\alias{run_lightgbm}
\title{Run gradient boosting model with lightgbm}
\usage{
run_lightgbm(train, test, model_params, alpha, calc_shaps)
}
\arguments{
\item{train}{Dataframe of train data as returned by the \code{\link[=split_data_counterfactual]{split_data_counterfactual()}}
function.}

\item{test}{Dataframe of test data as returned by the \code{\link[=split_data_counterfactual]{split_data_counterfactual()}}
function.}

\item{model_params}{list of hyperparameters to use in lgb.train call.
See \code{\link[lightgbm:lgb.train]{lightgbm:lgb.train()}} params argument for details.}

\item{alpha}{Confidence level of the prediction interval between 0 and 1.}

\item{calc_shaps}{Boolean value. If TRUE, calculate SHAP values for the
method used and format them so they can be visualised with \code{\link[shapviz:sv_importance]{shapviz:sv_importance()}} and
\code{\link[shapviz:sv_dependence]{shapviz:sv_dependence()}}.
The SHAP values are generated for a subset (or all, depending on the size of the dataset) of the
test data.}
}
\value{
List with data frame of predictions and model
}
\description{
This function trains a gradient boosting model (lightgbm) on the
specified training dataset and makes predictions on the test dataset in a
counterfactual scenario. The model uses meteorological variables and temporal features.
}
\details{
Note: Runs the gradient boosting model for individualised use with own data pipeline.
Otherwise use \code{\link[=run_counterfactual]{run_counterfactual()}}  to call this function.
}
\examples{
\donttest{
data(mock_env_data)
split_data <- list(
  train = mock_env_data[1:80, ],
  apply = mock_env_data[81:100, ]
)
params <- load_params()
variables <- c("day_julian", "weekday", "hour", params$meteo_variables)
res <- run_lightgbm(
  train = mock_env_data[1:80, ],
  test = mock_env_data[81:100, ], params$lightgbm, alpha = 0.9,
  calc_shaps = FALSE
)
prediction <- res$dt_predictions
model <- res$model
}
}
