% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_lines.R
\name{tt_hline}
\alias{tt_hline}
\title{Add horizontal line to table}
\usage{
tt_hline(table, y, start = NULL, end = NULL, stroke = TRUE)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{y}{Position of the line (0 = top of table, 1 = below header,
2 = below first data row, etc.).}

\item{start}{Starting column for partial line (0-indexed, inclusive).}

\item{end}{Ending column for partial line (0-indexed, inclusive).}

\item{stroke}{Line style: \code{TRUE} for default, color name, or full stroke spec
like \code{"2pt + red"}.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Adds a horizontal line at a specific position in the table.
}
\examples{
# Add line below header
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_hline(1)

# Add colored line
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_hline(1, stroke = "blue")

# Partial line spanning some columns
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_hline(1, start = 0, end = 2)

}
