% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtweedie_saddle.R
\name{dtweedie_saddle}
\alias{dtweedie_saddle}
\alias{dtweedie.saddle}
\title{Tweedie densities evaluation using the saddlepoint approximation}
\usage{
dtweedie_saddle(y, xi = NULL, mu, phi, eps = 1/6, power = NULL)

dtweedie.saddle(y, xi = NULL, mu, phi, eps = 1/6, power = NULL)
}
\arguments{
\item{y}{vector of quantiles.}

\item{xi}{scalar; the value of \eqn{\xi}{xi} such that the variance is \eqn{\mbox{var}[Y]=\phi\mu^{\xi}}{var[Y] = phi * mu^xi}. A synonym for \code{power}.}

\item{mu}{vector of mean \eqn{\mu}{mu}.}

\item{phi}{vector of dispersion parameters \eqn{\phi}{phi}.}

\item{eps}{the offset in computing the variance function; the default is \code{eps=1/6} (as suggested by Nelder and Pregibon, 1987).}

\item{power}{scalar; a synonym for \eqn{\xi}{xi}, the Tweedie index parameter.}
}
\value{
A numeric vector of densities.
}
\description{
Density function for the Tweedie EMDs using a saddlepoint approximation.
}
\examples{
# Plot a Tweedie density
y <- seq(0.01, 4, length = 50)
fy <- dtweedie_saddle(y, power = 1.1, mu = 1, phi = 1)
plot(y, fy, type = "l", lwd = 2, ylab = "Density")


}
\references{
Dunn, P. K. and Smyth, G. K. (2008).
Evaluation of Tweedie exponential dispersion model densities by Fourier inversion.
\emph{Statistics and Computing}, 
\bold{18}, 73--86.
\doi{10.1007/s11222-007-9039-6}

Dunn, Peter K and Smyth, Gordon K (2005).
Series evaluation of Tweedie exponential dispersion model densities
\emph{Statistics and Computing},
\bold{15}(4). 267--280.
\doi{10.1007/s11222-005-4070-y}

	Nelder, J. A. and Pregibon, D. (1987).
	An extended quasi-likelihood function
	\emph{Biometrika},
	\bold{74}(2), 221--232.
	\doi{10.1093/biomet/74.2.221}
}
\keyword{distribution}
