% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tteICE.R
\name{tteICE}
\alias{tteICE}
\title{Using formula to fit CIFs for time-to-event data with intercurrent events}
\usage{
tteICE(
  formula,
  add.scr = NULL,
  data,
  strategy = "composite",
  method = "np",
  weights = NULL,
  subset = NULL,
  na.rm = FALSE,
  nboot = 0,
  seed = 0
)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class).
A symbolic description of the model to be fitted.
For example, \code{formula=Surv(time, status, type="mstate")~treatment | baseline.covariate}.
The details of model specification are given under ‘Details’.}

\item{add.scr}{Required for semicompeting data.
An object of class "Surv" (or one that can be coerced to that class).
For example, \code{add.scr=~Surv(time.intercurrent, status.intercurrent)}.
The details of model specification are given under ‘Details’.}

\item{data}{Data or object coercible by as.data.frame to a data frame,
containing the variables in the model.}

\item{strategy}{Strategy to address intercurrent events, \code{"treatment"} indicating treatment policy strategy,
\code{"composite"} indicating composite variable strategy, \code{"natural"} indicating hypothetical strategy
(Scenario I, controlling the hazard of intercurrent events), \code{"removed"} indicating hypothetical strategy
(Scenario II, removing intercurrent events), \code{"whileon"} indicating while on treatment strategy, and
\code{"principal"} indicating principal stratum strategy.}

\item{method}{Estimation method, \code{"np"} indicating nonparametric estimation, \code{"np"} indicating inverse
treatment probability weighting, \code{"eff"} indicating semiparametrically efficient estimation based on efficient
influence functions.}

\item{weights}{Weight for each subject.}

\item{subset}{Subset, either numerical or logical.}

\item{na.rm}{Whether to remove missing values.}

\item{nboot}{Number of resamplings in the boostrapping method. If \code{nboot} is 0 or 1, then
asymptotic standard error based on the explicit form is calculated instead of bootstrapping.}

\item{seed}{Seed for bootstrapping.}
}
\value{
A list including the fitted object and input variables.
}
\description{
This function estimates the potential cumulative incidence function for time-to event data under ICH E9 (R1) to address intercurrent events.
The input data can be competing or semicompeting risks data structure.
}
\details{
\describe{
\item{Background}{Intercurrent events refer to the events occurring after treatment initiation of clinical trials that
affect either the interpretation of or the existence of the measurements associated with the clinical
question of interest. The International Conference on Harmonization (ICH) E9 (R1) addendum proposed
five strategies to address intercurrent events, namely, treatment policy strategy,
composite variable strategy, while on treatment strategy, hypothetical strategy, and principal stratum
strategy. To answer a specific scientific question, a strategy with a particular estimand is chosen
before the study design.}
\item{Model}{We adopt the potential outcomes framework that defines a causal estimand as the contrast between
functionals of potential outcomes. Consider a randomized controlled trial with \eqn{n} individuals
randomly assigned to one of two treatment conditions, denoted by \eqn{w}, where \eqn{w = 1} represents
the active treatment (a test drug) and \eqn{w = 0} represents the control (placebo). Assume that all
patients adhere to their treatment assignments and do not discontinue treatment. Associated with individual
\eqn{i = 1, ..., n} are two potential time-to-event primary outcomes \eqn{T_i(1)} and \eqn{T_i(0)},
if any, which represent the time durations from treatment initiation to the primary outcome event under
two treatment assignments respectively. Let \eqn{R_i(1)} and \eqn{R_i(0)} denote the occurrence time of
potential intercurrent events, if any, under the two treatment assignments, respectively. Intercurrent
events are considered as absent if no post-treatment intercurrent events occur until the end of study.}
\item{Estimand}{We adopt the potential cumulative incidences under both treatment assignments as the target estimands.
Potential cumulative incidences describe the probability of time-to-event outcomes occurring at each
time point. We define the treatment effect as the contrast of two potential cumulative incidences.
Cumulative incidences are model-free and collapsible, enjoying causal interpretations.}
\item{Formula specifications}{
The formula should be set as the following two ways.

When data take format of competing risk data, set the first argument \code{formula = Surv(time, status, type="mstate") ~ treatment | covariate1+covariate2}
or \code{formula = Surv(time, status)~ A} without any baseline covariates, where \code{status}=0,1,2 (1 for the primary event, 2 for the intercurrent event, and 0 for censoring).

When data take the format of semicompeting risk data, set the first argument \code{formula = Surv(time, status) ~ treatment | covariate1+covariate2}
or \code{formula = Surv(time, status)~ A} without any baseline covariates, where \code{status}=0,1 (1 for the primary event and 0 for censoring).
In addition, the second argument \code{add.scr = ~ Surv(time.intercurrent, status.intercurrent)} is required.
}
}
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
X = as.matrix(bmt[,c('z1','z3','z5')])
bmt$A = A

library(survival)
## Composite variable strategy,
## nonparametric estimation without covariates
## Composite variable strategy,
## nonparametric estimation without covariates

## model fitting for competing risk data without covariates
fit1 = tteICE(Surv(t2, d4, type = "mstate")~A,
 data=bmt, strategy="composite", method='eff')
print(fit1)

## model fitting for competing risk data without covariates
## with bootstrap confidence intervals
fit.bt1 = tteICE(Surv(t2, d4, type = "mstate")~A,
 data=bmt, strategy="composite", method='eff', nboot=20, seed=2)
print(fit.bt1)

## model fitting for competing risk data with covariates
fit2 = tteICE(Surv(t2, d4, type = "mstate")~A|z1+z3+z5,
 data=bmt, strategy="composite", method='eff')
print(fit2)

## model fitting for semicompeting risk data without covariates
fitscr1 = tteICE(Surv(t1, d1)~A, ~Surv(t2, d2),
 data=bmt, strategy="composite", method='eff')
print(fitscr1)

## model fitting for semicompeting risk data without covariates
fitscr2 = tteICE(Surv(t1, d1)~A|z1+z3+z5, ~Surv(t2, d2),
 data=bmt, strategy="composite", method='eff')
print(fitscr2)


}
\references{
Deng, Y., Han, S., & Zhou, X. H. (2025).
Inference for Cumulative Incidences and Treatment Effects in Randomized Controlled Trials With Time-to-Event Outcomes Under ICH E9 (R1).
\emph{Statistics in Medicine}. \doi{10.1002/sim.70091}
}
\seealso{
\code{\link[tteICE]{surv.boot}}, \code{\link[tteICE]{scr.tteICE}}
}
