% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sketchPhylo3D.R
\name{sketchPhylo3D}
\alias{sketchPhylo3D}
\alias{addSketchPhylo3D}
\title{Sketch a phylo3D object}
\usage{
sketchPhylo3D(
  tree,
  show_node_enum = FALSE,
  ratio_of_edges = 1,
  number_of_edges = NULL,
  min_edge_diam = NULL,
  lwd_factor = 100
)

addSketchPhylo3D(
  tree,
  offset = c(0, 0, 0),
  show_node_enum = FALSE,
  ratio_of_edges = 1,
  number_of_edges = NULL,
  min_edge_diam = NULL,
  lwd_factor = 100
)
}
\arguments{
\item{tree}{A rooted tree in phylo3D format (no special node enumeration
required, except that nodes are numbered from 1 to |V| = the total number of
nodes). There must be at least 2 nodes, i.e. one edge. The attributes
'node.coord' and 'edge.weight' are strictly required. \cr
Optional: Add attribute edge.color' (character vector, e.g.
c("red","blue", "red", "gray30",...)) to the pylo3D object to sketch
the edges differently. If it is not given, every edge is
depicted as "gray30" by default. \cr
The attribute edge.diam' can be added optionally to  set the edge diameters,
otherwise the edge diameters will be calculated based on the edge lengths
and the edge weights (treated as volume).}

\item{show_node_enum}{A boolean value (default FALSE). If true each node
of the visualized phylo3D object is marked with its number. This helps to
identify specific nodes and edges.}

\item{ratio_of_edges}{A numeric value (>0 and <=1, default 1) that
indicates the ratio of edges that should be visualized (beginning with
the widest edges). This can be ignored, i.e. set to NULL, if
'number_of_edges' or 'min_edge_diam' is set. If the parameters are
conflicting: 'ratio_of_edges' trumps 'number_of_edges' trumps
'min_edge_diam'.}

\item{number_of_edges}{An integer value (>0, default NULL) indicating how
many of the edges should be visualized (beginning with the widest edges).
This can be ignored, i.e. left at NULL, if 'ratio_of_edges' or
'min_edge_diam' is set. If the parameters are conflicting: 'ratio_of_edges'
trumps 'number_of_edges' trumps 'min_edge_diam'.}

\item{min_edge_diam}{A numeric value (default NULL) that
indicates that only edges with equal or larger diameter should be visualized.
This can be ignored, i.e. left at NULL, if
'number_of_edges' is set. If the parameters are conflicting: 'ratio_of_edges'
trumps 'number_of_edges' trumps 'min_edge_diam'.}

\item{lwd_factor}{A numeric vlaue (>0, default 100) to increase or decrease
the line width.}

\item{offset}{Numeric vector of length 3, contains 3D coordinates by which
the phylo object should be shifted (default = c(0,0,0), i.e. no shift).}
}
\description{
\code{sketchPhylo3D} - Sketches a phylo3D object using functions of the
package 'rgl'. This is a much faster but rougher version of
\code{plotPhylo3D} as the resulting sketch is using lines instead of
cylinders and the user can specify in various ways that only a portion of
the edges will be depicted. This is intended to get a quick overview of a
phylo3D object that consists of thousands of edges and would therefore take
very long to plot regularly.

\code{addSketchPhylo3D} - This function sketches a phylo3D object without any
coordinate axis or adds the tree to an existing sketch
(e.g. for sketchPhylo3D). This is a much faster but rougher version of
\code{addPhylo3D} as the resulting sketch is using lines instead of
cylinders and the user can specify in various ways that only a portion of
the edges will be depicted. This is intended to get a quick overview of a
phylo3D object that consists of thousands of edges and would therefore take
very long to plot regularly.
}
\examples{
tree <- treeDbalance::example3Dtrees$bean09
sketchPhylo3D(tree, show_node_enum = TRUE, ratio_of_edges = 0.8)
addSketchPhylo3D(tree,
  offset = c(1, 1, 0), ratio_of_edges = NULL,
  number_of_edges = 200
)
}
\author{
Sophie Kersting
}
