% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imbalanceProfiles.R
\name{imbalProfile}
\alias{imbalProfile}
\title{Calculation of 3D imbalance profiles}
\usage{
imbalProfile(tree, imbal_type, max.seclen)
}
\arguments{
\item{tree}{A rooted tree in phylo3D format (no special node enumeration
required, except that nodes are numbered from 1 to |V| = the total number of
nodes). There must be at least 2 nodes, i.e., one edge. The attributes
'node.coord' and 'edge.weight' are strictly required.}

\item{imbal_type}{Specifies which node imbalance measurement should be
used. Available are:\cr
"A"     - centroid angle\cr
"alpha" - minimal centroid angle\cr
"M"     - expanded relative centroid distance\cr
"mu"    - relative centroid distance}

\item{max.seclen}{Numeric value >0 that specifies the maximal section length.}
}
\value{
\code{imbalProfile} Numeric matrix with five columns. The rows each
represent the values of a single tree node or edge subdivision. The first
column contains the z-coordinate (height), the second the root path length,
the third the (nearest) descendant leaf path length, and the fourth the
imbalance value. The fifth column stores the number of the corresponding
edge.
}
\description{
\code{imbalProfile} - Calculates the database for a 3D imbalance profile of
a 3D tree in phylo3D format for any of the four node imbalance approaches:
relative centroid distance, expanded relative centroid distance, centroid
angle, or minimal centroid angle. It is also used as a basis to visualize the
imbalance in a 3D plot, i.e., functions \code{plotImbalPhylo3D} and
\code{addImbalPhylo3D}.\cr
The profile is computed with regards to the z-coordinate (height), path
length to the root, and path length to the nearest descendant leaf of the
nodes.\cr
The accuracy can be determined by defining the maximal section length
\code{max.seclen}, which means that an edge with length \eqn{l} will be
subdivided ceiling(\eqn{l}/\code{max.seclen})-1 times into parts of equal
length and all subdividing nodes will be analyzed for their node imbalance.
For example, an edge \eqn{(p,v)} of length 3 with a maximal section length
of 1 would be subdivided twice and would then be evaluated for three points
in total: for \eqn{v} itself and for the two subdivisions at \eqn{1/3} and
\eqn{2/3} of the edge length.
}
\examples{
tree <- treeDbalance::extendPhylo(treeDbalance::example3Dtrees$bean09)
imbalProfile(tree, imbal_type = "mu", max.seclen = 1)
}
\author{
Sophie Kersting
}
