% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo3D-methods.R
\name{print.phylo3D}
\alias{print.phylo3D}
\alias{plot.phylo3D}
\alias{summary.phylo3D}
\title{Print, summary and plot methods for phylo3D objects}
\usage{
\method{print}{phylo3D}(x, ...)

\method{plot}{phylo3D}(x, edge_col = "black", edge_lwd_scale = 1, show_leaf_label = FALSE, ...)

\method{summary}{phylo3D}(object, ...)
}
\arguments{
\item{x}{An object of class \code{phylo3D}.}

\item{...}{Additional arguments passed to \code{plot()}.}

\item{edge_col}{Color for the edges (default "black").}

\item{edge_lwd_scale}{Scaling factor (default 1) for line width for the
edges.}

\item{show_leaf_label}{Logical (default FALSE), specifying if tip labels
should be depicted.}

\item{object}{An object of class \code{phylo3D}.}
}
\value{
\code{print.phylo3D} The input \code{phylo3D} object, returned
invisibly. Called primarily for its side effect of printing a
human-readable summary to the console.

The input \code{phylo3D} object, returned invisibly. This function is
called for its side effect of displaying a plot.

\code{summary.phylo3D} An object of class \code{summary.phylo3D},
which contains summary information about the \code{phylo3D} object.
}
\description{
\code{print.phylo3D} prints the contents of an object of class \code{phylo3D}.
It provides a brief summary of the object structure and its contents.

\code{plot.phylo3D} creates a 2D projection plot of a \code{phylo3D} object,
using the X and Z coordinates of each node. Each edge is drawn as a line
segment between parent and child nodes.\cr
For more elaborate 3D visualizations use \code{plotPhylo3D()} or
\code{addPhylo3D()}, \code{plotImbalPhylo3D()} or
\code{addImbalPhylo3D()}, or \code{sketchPhylo3D()}.

\code{summary.phylo3D} provides a summary of an object of class
\code{phylo3D}. It offers a high-level overview of the contents and their
structure.
}
\examples{
# Printing a 'phylo3D' object:
tree <- treeDbalance::extendPhylo(treeDbalance::example3Dtrees$bean09)
tree # same as print(tree)
# Simple plot of a 'phylo3D' object:
plot(tree, edge_col = "blue", show_leaf_label = TRUE)
# Summary of a 'phylo3D' object:
summary(tree)
str(summary(tree))
}
