% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractTopology.R
\name{extractTopology}
\alias{extractTopology}
\title{Extract the non-3D topology of trees in phylo(3D) format}
\usage{
extractTopology(tree)
}
\arguments{
\item{tree}{A rooted tree in (extended) phylo(3D) format
(no special node enumeration required, except that nodes are numbered
from 1 to |V| = the total number of nodes). There must be at least 2 nodes,
i.e. one edge.}
}
\value{
\code{extractTopology(tree)} Tree in phylo format with cladewise
node enumeration in which all interior nodes have at least out-degree 2.
}
\description{
\code{extractTopology} - Extracts the topology of a rooted tree in phylo or
phylo3D format by ignoring edge subdivisions, i.e. nodes with both in- and
out-degree of 1. The nodes have to be enumerated from 1 to \eqn{|V|}
(otherwise use enum2_1toV()).\cr
The function works for trees in phylo as well as phylo3D format as existing
information on the coordinates or edge weights is dropped anyway.\cr
Edge lengths in the topology are based on the sum of the edge lengths of
the corresponding paths in the original tree.
}
\examples{
tree <- treeDbalance::example3Dtrees$bean09
top <- extractTopology(tree)
}
\author{
Sophie Kersting, Luise Kühn
}
