% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combined3DIndices.R
\name{combined3DIndex}
\alias{combined3DIndex}
\title{Calculation of combined 3D imbalance indices}
\usage{
combined3DIndex(
  tree,
  imbal_type,
  weight = "edge_weight",
  root_weight_factor = 1,
  vertical_axis = c(0, 0, 1)
)
}
\arguments{
\item{tree}{A rooted tree in phylo3D format (no special node enumeration
required, except that nodes are numbered from 1 to |V| = the total number of
nodes). There must be at least 2 nodes, i.e., one edge. The attributes
'node.coord' and 'edge.weight' are strictly required.}

\item{imbal_type}{Specifies which node imbalance measurement should be used.
Available are:\cr
"A"     - centroid angle\cr
"alpha" - minimal centroid angle\cr
"M"     - expanded relative centroid distance\cr
"mu"    - relative centroid distance}

\item{weight}{Specifies how the node imbalance values should be weighted.
Available weighting methods are: \cr
"edge_weight" (default) -> Imbalance with regards to the total edge
weight.\cr
"edge_length" -> Imbalance with regards to the total edge length.}

\item{root_weight_factor}{Numeric value >0 (default 1), which specifies the
weight of the root imbalance value in the weighted mean. For example, a
weight of 1 means that both the imbalance index value of the whole tree as
well as the root imbalance value contribute equally, i.e., the unweighted
mean of the two values is returned. For a larger value, the influence of
the root imbalance value increases.\cr
If the weight is set to infinity (\code{Inf}), then the pure root
imbalance value is returned.}

\item{vertical_axis}{Numeric vector of length 3 (default (0,0,1)), which
specifies the given vertical axis for the given tree model. For example,
use the default (0,0,1) for models that grow straight upwards (e.g., trees)
and (0,0,-1) for models that grow downwards (e.g., roots). The vector (0,0,0)
is not allowed.}
}
\value{
\code{combined3DIndex} Numeric value in the interval between 0
(included) and 1 (excluded). A value near 1 indicates a higher degree and
near 0 a lower degree of asymmetry.
}
\description{
\code{combined3DIndex} - Calculates either the pure root imbalance value
with regard to a specified vertical axis or the combined 3D imbalance
index value of a 3D tree in phylo3D format.
The latter is a weighted mean of the integral-based 3D imbalance index
value (i.e., \code{A_Index}, \code{alpha_Index}, \code{M_Index}, or
\code{mu_Index} with edge length or edge weight based weighting) as well as
the root imbalance value.
}
\examples{
tree <- treeDbalance::extendPhylo(treeDbalance::example3Dtrees$bean09)
combined3DIndex(tree,
  imbal_type = "A", weight = "edge_weight",
  root_weight_factor = 2, vertical_axis = c(0, 0, 1)
)
combined3DIndex(tree,
  imbal_type = "A", root_weight_factor = Inf,
  vertical_axis = c(0, 0, 1)
)
}
\author{
Sophie Kersting
}
