% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_summary_stats.R
\encoding{UTF-8}
\name{calc_summary_stats_traces}
\alias{calc_summary_stats_traces}
\title{Calculates the Effective Sample Sizes of the traces of multiple
  estimated variables}
\usage{
calc_summary_stats_traces(traces, sample_interval)
}
\arguments{
\item{traces}{a data frame with traces of estimated parameters.
Assumes the burn-ins are removed.}

\item{sample_interval}{the interval in timesteps between samples}
}
\value{
the effective sample sizes
}
\description{
Calculates the Effective Sample Sizes of the traces of multiple
  estimated variables
}
\examples{
estimates_all <- parse_beast_tracelog_file(
  get_tracerer_path("beast2_example_output.log")
)
estimates <- remove_burn_ins(estimates_all, burn_in_fraction = 0.1)

calc_summary_stats_traces(
  estimates,
  sample_interval = 1000
)
}
\seealso{
Use \code{\link{remove_burn_ins}} to remove the burn-ins
  of all traces
}
\author{
Richèl J.C. Bilderbeek
}
