% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_esses.R
\encoding{UTF-8}
\name{calc_esses}
\alias{calc_esses}
\title{Calculates the Effective Sample Sizes from a parsed BEAST2 log file}
\usage{
calc_esses(traces, sample_interval)
}
\arguments{
\item{traces}{a dataframe with traces with removed burn-in}

\item{sample_interval}{the interval in timesteps between samples}
}
\value{
the effective sample sizes
}
\description{
Calculates the Effective Sample Sizes from a parsed BEAST2 log file
}
\examples{
# Parse an example log file
estimates <- parse_beast_tracelog_file(
  get_tracerer_path("beast2_example_output.log")
)

# Calculate the effective sample sizes of all parameter estimates
calc_esses(estimates, sample_interval = 1000)
}
\author{
Richèl J.C. Bilderbeek
}
