% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_time_series.R
\name{db_ts_get_last_update}
\alias{db_ts_get_last_update}
\title{Get the times series last update}
\usage{
db_ts_get_last_update(con, ts_keys, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Get the times series last update
}
\examples{

\dontrun{
db_ts_store(con = connection, zrh_airport, schema = "schema")

# get last update for one key
db_ts_get_last_update(
  con = connection,
  ts_keys = "ch.zrh_airport.departure.total",
  schema = "schema")

# get last update for multiple keys
db_ts_get_last_update(
  con = connection,
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.arrival.total"
  ),
  schema = "schema"
)
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
