% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_time_series.R
\name{db_collection_read_ts}
\alias{db_collection_read_ts}
\title{Read all Time Series in a User Collection}
\usage{
db_collection_read_ts(
  con,
  collection_name,
  collection_owner,
  valid_on = NULL,
  respect_release_date = FALSE,
  schema = "timeseries",
  chunksize = 10000
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{collection_name}{\strong{character} name of a collection to read. Collection are bookmark lists that contain time series keys.}

\item{collection_owner}{\strong{character} username that is the owner of a collection.}

\item{valid_on}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. valid_on selects the
version of a time series that is valid at the specified time.}

\item{respect_release_date}{\strong{boolean} indicating if it should the release embargo of a time series be respected. Defaults to FALSE. This option makes sense when the function is used in an API. In that sense, users do not have direct access to this function and therefore cannot simply switch parameters.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}

\item{chunksize}{set a limit of the number of time series requested in the function.}
}
\description{
Read all Time Series in a User Collection
}
\details{
Collections are identified by their name and owner. Several collections
with the same name but different owners may exist, therefore both need to be supplied
in order to uniquely identify a collection.
}
\examples{

\dontrun{

db_ts_store(con = connection, zrh_airport, schema = "schema")
db_ts_store(con = connection, kof_ts, schema = "schema")

db_collection_add_ts(
  con = connection,
  collection_name = "barometer and departures zurich",
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.departure.total",
    "ch.kof.barometer"
  ),
  schema = "schema"
)

db_collection_read_ts(
  con = connection,
  collection_name = "barometer and departures zurich",
  collection_owner = "user_name",
  schema = "schema"
)
}
}
\seealso{
Other time series functions: 
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
