% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflows.R
\name{tl_auto_ml}
\alias{tl_auto_ml}
\title{High-Level Workflows for Common Machine Learning Patterns}
\usage{
tl_auto_ml(
  data,
  formula,
  task = "auto",
  use_reduction = TRUE,
  use_clustering = TRUE,
  time_budget = 300,
  cv_folds = 5,
  metric = NULL
)
}
\arguments{
\item{data}{A data frame}

\item{formula}{Model formula (for supervised learning)}

\item{task}{Task type: "classification", "regression", or "auto" (default)}

\item{use_reduction}{Whether to try dimensionality reduction (default: TRUE)}

\item{use_clustering}{Whether to add cluster features (default: TRUE)}

\item{time_budget}{Time budget in seconds (default: 300)}

\item{cv_folds}{Number of cross-validation folds (default: 5)}

\item{metric}{Evaluation metric (default: auto-selected based on task)}
}
\value{
Best model with performance comparison
}
\description{
These functions provide end-to-end workflows that showcase tidylearn's
ability to seamlessly combine multiple learning paradigms
Auto ML: Automated Machine Learning Workflow
}
\details{
Automatically explores multiple modeling approaches including
dimensionality reduction, clustering, and various supervised methods.
Returns the best performing model based on cross-validation.
}
\examples{
\donttest{
# Automated modeling
result <- tl_auto_ml(iris, Species ~ .)
best_model <- result$best_model
result$leaderboard
}
}
