% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_importance.R
\name{calculate_vimp}
\alias{calculate_vimp}
\title{Calculate Variable Importance of HTEs}
\usage{
calculate_vimp(
  full_data,
  weight_col,
  pseudo_outcome,
  ...,
  .VIMP_cfg,
  .Model_cfg
)
}
\arguments{
\item{full_data}{dataframe}

\item{weight_col}{Unquoted name of the weight column.}

\item{pseudo_outcome}{Unquoted name of the pseudo-outcome.}

\item{...}{Unquoted names of covariates to include in the joint effect model.
The variable importance will be calculated for each of these covariates.}

\item{.VIMP_cfg}{A \code{VIMP_cfg} object defining how VIMP should be estimated.}

\item{.Model_cfg}{A \code{Model_cfg} object defining how the joint effect model should be estimated.}
}
\description{
\code{calculate_vimp} estimates the reduction in (population) $R^2$ from
removing a particular moderator from a model containing all moderators.
}
\references{
\itemize{
\item Williamson, B. D., Gilbert, P. B., Carone, M., & Simon, N. (2021).
Nonparametric variable importance assessment using machine learning techniques.
Biometrics, 77(1), 9-22.
\item Williamson, B. D., Gilbert, P. B., Simon, N. R., & Carone, M. (2021).
A general framework for inference on algorithm-agnostic variable importance.
Journal of the American Statistical Association, 1-14.
}
}
\seealso{
\code{\link[=calculate_linear_vimp]{calculate_linear_vimp()}}
}
\keyword{internal}
