% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_missing_pattern.R
\name{ild_missing_pattern}
\alias{ild_missing_pattern}
\title{Summarize missingness pattern in ILD}
\usage{
ild_missing_pattern(x, vars = NULL)
}
\arguments{
\item{x}{An ILD object (see [is_ild()]).}

\item{vars}{Optional character vector of variable names to summarize.
If missing, all non-.ild_* columns (except id/time) are used.}
}
\value{
A list with:
  - `by_id`: data frame with one row per person, columns id and for each
    var the count (or proportion) of non-missing and missing.
  - `overall`: named vector or list of overall missing counts/proportions
    per variable.
  - `n_complete`: number of rows with no missing in selected vars.
}
\description{
Returns a tabular summary of missingness by person and/or by variable.
Complements [ild_summary()] and supports checking data before modeling.
}
