% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_misc.R
\name{rm_n_msa}
\alias{rm_n_msa}
\title{Remove Ns introduced in 'mergePairs(justConcatenate = T)'}
\usage{
rm_n_msa(
  msa,
  pattern_n = paste0(rep("N", 10), collapse = ""),
  outfasta = FALSE
)
}
\arguments{
\item{msa}{Multiple sequence alignment stored as a "DNAMultipleAlignment"
or "DNAStringSet".}

\item{pattern_n}{N string to match.}

\item{outfasta}{Character vector with path to write FASTA file with MSA.}
}
\value{
Filtered BStringSet MSA.
}
\description{
Detect N strings and remove them from aligned BStringSet MSA.
}
\details{
When using 'mergePairs(justConcatenate = T)', a string of 10
Ns is introduced between paired-end concatenated reads.
This function detects the coordinates of the N string in the MSA and removes
it. It uses 'matchPattern()' to detect patterns.
WARNING: it has not been tested for multiple hits of the pattern.
It could potentially work with other patterns in addition to N strings,
but it has not been tested.
}
