% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_intelligence_classes.R
\name{qoq}
\alias{qoq}
\title{Current full period quarter over previous full period quarter}
\usage{
qoq(
  .data,
  .date,
  .value,
  calendar_type = "standard",
  lag_n = 1,
  fiscal_year_start = 1
)
}
\arguments{
\item{.data}{tibble or dbi object (either grouped or ungrouped)}

\item{.date}{the date column to group by}

\item{.value}{the value column to summarize}

\item{calendar_type}{select either 'standard', '445', '454', or '544' calendar, see 'Details' for additional information}

\item{lag_n}{the number of periods to lag}

\item{fiscal_year_start}{integer 1-12, the month the fiscal year starts nearest to (default 1 = January). Only used with retail calendars ('445', '454', '544').}
}
\value{
ti object
}
\description{
\itemize{
\item This calculates the full quarter value compared to the previous quarter value respecting
any groups that are passed through with \code{\link[dplyr:group_by]{dplyr::group_by()}}
\item Use \link{calculate} to return the results
}
}
\examples{
\donttest{
qoq(contoso::sales,.date=order_date,.value=quantity,calendar_type='standard',lag_n=1)
}
}
\seealso{
Other time_intelligence: 
\code{\link{atd}()},
\code{\link{dod}()},
\code{\link{mom}()},
\code{\link{momtd}()},
\code{\link{mtd}()},
\code{\link{mtdopm}()},
\code{\link{pmtd}()},
\code{\link{pqtd}()},
\code{\link{pwtd}()},
\code{\link{pytd}()},
\code{\link{qoqtd}()},
\code{\link{qtd}()},
\code{\link{qtdopq}()},
\code{\link{wow}()},
\code{\link{wowtd}()},
\code{\link{wtd}()},
\code{\link{wtdopw}()},
\code{\link{yoy}()},
\code{\link{yoytd}()},
\code{\link{ytd}()},
\code{\link{ytdopy}()}
}
\concept{time_intelligence}
