% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_1_textTopics.R
\name{textTopics}
\alias{textTopics}
\title{BERTopic}
\usage{
textTopics(
  data,
  variable_name,
  embedding_model = "distilroberta",
  representation_model = c("mmr", "keybert"),
  umap_n_neighbors = 15L,
  umap_n_components = 5L,
  umap_min_dist = 0,
  umap_metric = "cosine",
  hdbscan_min_cluster_size = 5L,
  hdbscan_min_samples = NULL,
  hdbscan_metric = "euclidean",
  hdbscan_cluster_selection_method = "eom",
  hdbscan_prediction_data = TRUE,
  num_top_words = 10L,
  n_gram_range = c(1L, 3L),
  stopwords = "english",
  min_df = 5L,
  bm25_weighting = FALSE,
  reduce_frequent_words = TRUE,
  set_seed = 8L,
  save_dir
)
}
\arguments{
\item{data}{A \code{tibble}/\code{data.frame} containing a text variable to analyze and,
optionally, additional numeric/categorical variables that can be used in later analyses
(e.g., testing topic prevalence differences across groups).}

\item{variable_name}{A character string giving the name of the text variable in \code{data}
to perform topic modeling on.}

\item{embedding_model}{A character string specifying which embedding model to use.
Common options include \code{"miniLM"}, \code{"mpnet"}, \code{"multi-mpnet"},
and \code{"distilroberta"}. The choice affects topic quality, speed, and memory usage.}

\item{representation_model}{A character string specifying the topic representation method.
Must be one of \code{"mmr"} or \code{"keybert"}.
\itemize{
  \item \code{"keybert"} uses embedding similarity to select representative words/phrases.
  \item \code{"mmr"} (Maximal Marginal Relevance) promotes diversity among selected terms.
}}

\item{umap_n_neighbors}{Integer. Number of neighbors used by UMAP to balance local versus
global structure. Smaller values emphasize local clusters; larger values emphasize global structure.}

\item{umap_n_components}{Integer. Number of dimensions to reduce to with UMAP (the embedding
space used for clustering).}

\item{umap_min_dist}{Numeric. Minimum distance between embedded points in UMAP. Smaller values
typically yield tighter clusters.}

\item{umap_metric}{Character string specifying the distance metric used by UMAP, e.g.
\code{"cosine"}.}

\item{hdbscan_min_cluster_size}{Integer. The minimum cluster size for HDBSCAN. Larger values
yield fewer, broader topics; smaller values yield more, finer-grained topics.}

\item{hdbscan_min_samples}{Integer or \code{NULL}. Controls how conservative clustering is.
If \code{NULL}, HDBSCAN chooses a default.}

\item{hdbscan_metric}{Character string specifying the metric used by HDBSCAN, typically
\code{"euclidean"} when clustering in reduced UMAP space.}

\item{hdbscan_cluster_selection_method}{Character string specifying cluster selection strategy.
Either \code{"eom"} (excess of mass; often yields more stable clusters) or \code{"leaf"}
(can yield more fine-grained clusters).}

\item{hdbscan_prediction_data}{Logical. If \code{TRUE}, stores additional information enabling
approximate topic prediction for new documents (when supported by the underlying pipeline).}

\item{num_top_words}{Integer. Number of top terms to return per topic.}

\item{n_gram_range}{Integer vector of length 2 giving the min and max n-gram length used by
the vectorizer (e.g., \code{c(1L, 3L)}).}

\item{stopwords}{Character string naming the stopword dictionary to use (e.g. \code{"english"}).}

\item{min_df}{Integer. Minimum document frequency for terms included in the vectorizer.}

\item{bm25_weighting}{Logical. If \code{TRUE}, uses BM25 weighting in the class-based TF-IDF
transformer (can improve term weighting in some corpora).}

\item{reduce_frequent_words}{Logical. If \code{TRUE}, down-weights very frequent words using
the class-based TF-IDF transformer.}

\item{set_seed}{Integer. Random seed used to initialize UMAP (and other stochastic components)
for reproducibility.}

\item{save_dir}{Character string specifying the directory where outputs should be saved.
A folder will be created (or reused) to store the fitted model and derived outputs.}
}
\value{
A named list containing:
\describe{
  \item{train_data}{The training data used to fit the model (or loaded from disk if available).}
\item{preds}{A document-by-topic matrix of normalized topic mixtures (LDA-like).
  Rows typically sum to 1; rows of zeros can occur if no topic mass was assigned.}
  \item{doc_info}{Document-level outputs including hard topic labels (\code{-1} indicates outliers).}
  \item{topic_info}{Topic-level outputs including topic sizes and top terms.}
  \item{model}{The fitted BERTopic model object (Python-backed).}
  \item{model_type}{Model identifier (currently \code{"bert_topic"}).}
  \item{seed}{Random seed used.}
  \item{save_dir}{Directory where artifacts were saved.}
}
}
\description{
\code{textTopics()} trains a BERTopic model (via the \pkg{bertopic} Python package) on a
text variable in a \code{tibble}/\code{data.frame}. The function embeds documents, reduces
dimensionality (UMAP), clusters documents (HDBSCAN), and extracts topic representations
using c-TF-IDF with optional KeyBERT/MMR-based representation. (EXPERIMENTAL)
}
\details{
Typical tuning levers:
\itemize{
  \item \strong{More topics / finer clusters}: decrease \code{hdbscan_min_cluster_size},
    decrease \code{umap_n_neighbors}, and/or increase \code{umap_n_components}.
  \item \strong{Fewer topics / broader clusters}: increase \code{hdbscan_min_cluster_size}
    and/or increase \code{umap_n_neighbors}.
  \item \strong{More phrase-like terms}: increase \code{n_gram_range} max (e.g., up to 3).
  \item \strong{Cleaner vocabulary}: increase \code{min_df}, and use \code{reduce_frequent_words = TRUE}.
}
}
\examples{
\dontrun{
res <- textTopics(
  data = Language_based_assessment_data_8,
  variable_name = "harmonytexts",
  embedding_model = "distilroberta",
  representation_model = "mmr",
  min_df = 3,
  save_dir = "bertopic_results"
)

}

}
\seealso{
\code{\link{textTopicsReduce}}, \code{\link{textTopicsTest}},
  \code{\link{textTopicsWordcloud}}
}
