% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tests_stf.R
\name{unrowname}
\alias{unrowname}
\title{Add Identifier Column and Remove Row Names from a Data Frame}
\usage{
unrowname(identifier, ret, label)
}
\arguments{
\item{identifier}{Character. The identifier to insert into the resulting
data frame (typically the name of the list element being processed).}

\item{ret}{List of data frames, usually the output of applying a mapping
or extraction function across multiple parsed test blocks.}

\item{label}{Character. Name of the column used to store the identifier
(e.g., \code{"test"} or \code{"file"}).}
}
\value{
A \code{data.frame} with an identifier column prepended and row names
removed. The remaining columns retain their original structure.
}
\description{
This internal helper restructures a data frame by adding an identifier
column (e.g., file name or test label) and removing row names. It is used
by STF parsing functions to attach contextual labels (such as test block
names or file names) to expectation or test‑block structures.
}
\details{
The function:
\itemize{
  \item extracts the data frame corresponding to \code{identifier},
  \item appends a new column containing the identifier value,
  \item removes row names for clean downstream processing, and
  \item reorders columns so the identifier appears first.
}

This structure is used by STF mapping helpers such as
\code{nest_expect()} and \code{map_tests_stf()} to carry forward file or
test labels when constructing unified test‑mapping tables.
}
\keyword{internal}
