% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_covr_modes.R
\name{run_covr_modes}
\alias{run_covr_modes}
\title{Run Coverage Analysis with Test Detection}
\usage{
run_covr_modes(pkg_source_path, covr_timeout = 60)
}
\arguments{
\item{pkg_source_path}{Character. Path to the root directory of the 
package source.}

\item{covr_timeout}{Numeric. Timeout in seconds for running coverage 
analysis. Default is 60.}
}
\value{
A named list containing coverage results, package metadata, and test
configuration details. The returned list includes (but is not limited to):
\describe{
  \item{pkg_name}{Character. Package name extracted from the DESCRIPTION file.}
  \item{pkg_ver}{Character. Package version.}
  \item{date_time}{Timestamp of when the analysis was run.}
  \item{executor}{User or environment running the analysis.}
  \item{sysname, version, release, machine}{System metadata.}
  \item{r_version}{R version used during analysis.}
  \item{test_framework_type}{Character. Detected testing framework type.}
  \item{covr_list}{A nested list containing: 
    \describe{
      \item{total_cov}{Numeric. Aggregated coverage percentage.}
      \item{res_cov}{File‑level and line‑level coverage details.}
      \item{errors, notes}{Any warnings or notes detected during testing.}
    }
  }
  \item{test_pkg_data}{A list describing the test configuration of the
    package (presence of testthat, testit, base tests, snapshots, etc.).}
}

This function always returns a value. When no supported testing framework is
detected, a default object with zero coverage and diagnostic information is
returned.
}
\description{
This function inspects the test configuration of an R package and runs 
code coverage analysis using any available testing framework, including 
`testthat`, `testit`, base R test scripts, or Bioconductor-style tests. 
If no recognised testing configuration is found, a default zero‑coverage
result is returned.
}
\examples{
\donttest{

dp <- system.file("test-data", 
  "test.package.0001_0.1.0.tar.gz", 
  package = "test.assessr")

# set up package
install_list <- set_up_pkg(dp)

package_installed <- install_list$package_installed
pkg_source_path <- install_list$pkg_source_path

# install package locally to ensure test works
package_installed <- install_package_local(pkg_source_path)
package_installed <- TRUE

covr_mode_list <- run_covr_modes(pkg_source_path)

}

}
