% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_dependencies_into_env.R
\name{load_dependencies_into_env}
\alias{load_dependencies_into_env}
\title{Load and Install Package Dependencies from a DESCRIPTION File}
\usage{
load_dependencies_into_env(pkg_source_path, env)
}
\arguments{
\item{pkg_source_path}{`character(1)`. Path to a package source directory
containing a `DESCRIPTION` file.}

\item{env}{An environment into which exported symbols from packages listed
in the **Depends** field will be imported. This allows code evaluated in
`env` to resolve functions from those packages using bare names without
requiring attachment on the search path.}
}
\value{
Invisibly returns `TRUE` on success.
}
\description{
Reads a package's `DESCRIPTION` file, parses dependency fields
(`Depends`, `Imports`, `Suggests`), installs missing packages or those that
do not satisfy version constraints, loads namespaces, and—for packages listed
under **Depends**—imports their exported symbols into a provided evaluation
environment. This makes bare function names visible when evaluating code in
environments that do not inherit from `.GlobalEnv` (e.g., environments with
`baseenv()` as parent).
}
\details{
This function avoids calling `installed.packages()` because that function
scans all installed packages and is slow on some platforms (especially
Windows and network filesystems). Using `requireNamespace()` is the
recommended approach for checking whether a package is installed and usable.
`packageDescription()` is used only on a small set of packages when version
information or priority metadata is needed.

When evaluating code in environments that do not inherit from `.GlobalEnv`,
attaching packages does not necessarily make their exported symbols available.
For this reason, exports from packages listed under `Depends` are explicitly
imported into the target environment.
}
\section{Behavior}{


1. **Dependency parsing**  
   Parses entries of the form `"pkg"` or `"pkg (op version)"`, where the
   operator `op` is one of `>=`, `>`, `<=`, `<`, `==`. HTML-escaped forms
   (`&gt;`, `&lt;`) are normalized.

2. **Dependency fields**  
   Dependencies are extracted from the `Depends`, `Imports`, and `Suggests`
   fields. The `Depends: R (>= x.y.z)` entry is ignored for installation
   purposes, but the R version constraint is validated.

3. **Base/recommended packages**  
   Unlike tools such as `R CMD check`, this function **does not skip**
   recommended or base packages (e.g., `graphics`, `stats`, `utils`,
   `grDevices`) because packages listed in `Depends:` must be made visible
   in the target evaluation environment even when its parent is `baseenv()`.
   If a package is already installed with R, no installation is attempted.

4. **Availability and version checks**  
   Package presence is determined via `requireNamespace(pkg, quietly = TRUE)`
   instead of `installed.packages()`, for performance and portability.  
   If a version constraint is declared, the installed version (from
   `packageDescription(pkg, fields = "Version")`) is compared using
   `utils::compareVersion()`.

5. **Package installation**  
   - For constraints of the form `>=` or `>`:  
     `install.packages()` is used (latest version is assumed valid).  
   - For `<=`, `<`, or `==`:  
     `remotes::install_version()` is used to install an exact version.  

6. **Loading behavior**  
   Each dependency is namespace-loaded via `loadNamespace()`.  
   Packages that appear in the `Depends` field have all their **exported
   symbols imported** into the supplied `env`. This makes calls such as
   `plot()`, `lm()`, or `head()` resolve correctly inside environments whose
   parent is not `.GlobalEnv`.
}

\keyword{internal}
