% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_package_local.R
\name{install_package_local}
\alias{install_package_local}
\title{Install a Package from a Local Source Directory}
\usage{
install_package_local(pkg_source_path)
}
\arguments{
\item{pkg_source_path}{Character string. Path to the local package source
directory (e.g., an unpacked package or extracted tarball path).}
}
\value{
A logical value indicating whether the package is installed after running
the function.  

The returned object is always of class \code{logical}:
\itemize{
  \item \code{TRUE} — The package is already installed or was successfully installed.
  \item \code{FALSE} — Installation failed or the path does not exist.
}
}
\description{
Attempts to install an R package from a local source directory using
\code{remotes::install_local()}. The function reports on whether installation
succeeded, whether the package was already installed, or whether the provided
source path does not exist.
}
\details{
The display name of the package is derived from the input path using
\code{get_pkg_name()}.
}
\section{Output Meaning}{

\code{TRUE} does not necessarily imply that the installation occurred during
this function call—it may also mean the package was already installed.  

\code{FALSE} indicates a failure to install or an invalid path. All diagnostic
messages are printed via \code{message()} for user visibility.
}

\examples{
\dontrun{
results <- install_package_local("pkg_source_path")
print(results)
}
}
