% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_covr_skip_nstf.R
\name{get_nstf_test_path}
\alias{get_nstf_test_path}
\title{Collect All Applicable Nonstandard Test Paths for a Package (internal)}
\usage{
get_nstf_test_path(test_pkg_data, testdir)
}
\arguments{
\item{test_pkg_data}{\code{list}. A list of logical flags describing detected
test frameworks. Missing fields default to \code{FALSE}. Expected (optional)
fields include:
\itemize{
  \item \code{has_testthat}
  \item \code{has_testit}
  \item \code{has_tests_base}
  \item \code{has_bioc_unit_tests}
}}

\item{testdir}{\code{character}. Path to the package's \code{tests/} directory.
The package root is inferred as \code{dirname(testdir)} for detection of
Bioconductor-style \code{inst/unitTests/}.}
}
\value{
\code{list}. A named list of character vectors giving all detected
  applicable test directories. Possible names include:
  \itemize{
    \item \code{testthat} – path to \code{tests/testthat/}
    \item \code{testit} – path to \code{tests/testit/}
    \item \code{nonstandard_testit_root} – \code{tests/} when both
          \code{test-ci/} and \code{test-cran/} exist
    \item \code{base_tests_root} – \code{tests/} if \code{*.R} files exist directly
    \item \code{bioc_unitTests} – path to \code{inst/unitTests/}
    \item \code{default_tests_root} – fallback \code{tests/} directory
  }
}
\description{
This internal NSTF utility detects and returns all relevant test directories
used by an R package. It combines declared test framework flags in
\code{test_pkg_data} with filesystem-based detection for robustness.
}
\details{
Supported directory layouts include:
\itemize{
  \item \strong{testthat}: \code{tests/testthat/}
  \item \strong{testit} (standard): \code{tests/testit/}
  \item \strong{testit} (nonstandard): both \code{tests/test-ci/} and
        \code{tests/test-cran/} present, using \code{tests/} as the root
  \item \strong{base R tests}: \code{*.R} files directly under \code{tests/}
  \item \strong{Bioconductor unit tests}: \code{inst/unitTests/}
}

If no test directory of any supported type is detected, the output falls back
to a single entry:
\code{default_tests_root = <tests/>}.
}
\section{Output Meaning}{

The returned list describes all test frameworks detected in a package. Each
element is a filesystem path that the NSTF workflow should consider when
identifying or running tests. Duplicate paths (e.g., multiple roles pointing
to \code{tests/}) are automatically removed.
}

\seealso{
Other nstf_utility: 
\code{\link{check_covr_skip_nstf}()},
\code{\link{check_covr_skip_testit}()},
\code{\link{get_source_test_mapping_nstf}()},
\code{\link{run_covr_skip_nstf}()}
}
\concept{nstf_utility}
\keyword{internal}
