% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_covr_skip_bioc_nstf.R
\name{get_biocgenerics_test_paths}
\alias{get_biocgenerics_test_paths}
\title{Locate active test paths for Bioconductor RUnit layout}
\usage{
get_biocgenerics_test_paths(test_pkg_data, testdir)
}
\arguments{
\item{test_pkg_data}{list/env of test metadata; may include:
- `bioc_run_ut_path` (character): path to `tests/run_unitTests.R` wrapper, if present}

\item{testdir}{character: expected RUnit tests directory (typically "<pkg_root>/inst/unitTests")}
}
\value{
named list of **existing** directories (e.g., `bioc_unitTests`, `tests_root`);
        if nothing is found, returns a single `fallback` entry pointing to `testdir`.
}
\description{
Returns a *list* of one or more existing test directories suitable for
normalization and use in subsequent mapping (e.g., `get_source_test_mapping_nstf`).
Designed to work with:
}
\details{
path    <- as.character(pkg_source_path)
  testdir <- file.path(path, "inst/unitTests")
  test_path_list <- find_biocgenerics_test_paths(test_pkg_data, testdir)
  test_path <- normalizePath(
    unlist(test_path_list, use.names = TRUE),
    winslash = "/",
    mustWork = FALSE
  )
}
\keyword{internal}
