% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_covr_skip_stf.R
\name{create_results_summary}
\alias{create_results_summary}
\title{Create a Summary of Coverage Results}
\usage{
create_results_summary(cvr)
}
\arguments{
\item{cvr}{A covr coverage object, typically produced by
`covr::environment_coverage()` or by higher‑level wrapper functions in
this package (e.g., skip‑aware coverage for STF or NSTF workflows).}
}
\value{
A data frame containing summary statistics, including:
\describe{
  \item{total_cov}{Numeric. Overall percentage of lines covered.}
  \item{name}{Character. File or package name associated with the coverage result.}
  \item{coverage}{List or data structure summarizing file‑level or
        element‑level coverage from the covr object.}
  \item{errors}{Character vector containing any coverage‑related errors (if present).}
  \item{notes}{Additional diagnostic notes returned by coverage processing.}
}

The summary object is used by downstream reporting functions to
generate test coverage summaries and scoring metrics.
}
\description{
This function extracts overall test coverage and file‑level coverage
information from a covr coverage object. It provides a simplified
summary for downstream reporting and scoring.
}
\keyword{internal}
